<?php
/**
 * Custom post types configuration
 *
 * @package GoodTailor_Plugin
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Register the custom post types to be used in our theme
 */
function goodtailor_cpt_register_post_types() {
	// Add Excerpt support for Pages
	add_post_type_support( 'page', 'excerpt' );
	// Service
	$service_labels = array(
		'name'               => __( 'Services', 'goodtailor-plugin' ),
		'singular_name'      => __( 'Service', 'goodtailor-plugin' ),
		'add_new'            => __( 'Add New', 'goodtailor-plugin' ),
		'add_new_item'       => __( 'Add New Service', 'goodtailor-plugin' ),
		'edit_item'          => __( 'Edit Service', 'goodtailor-plugin' ),
		'new_item'           => __( 'New Service', 'goodtailor-plugin' ),
		'all_items'          => __( 'All Services', 'goodtailor-plugin' ),
		'view_item'          => __( 'View Service', 'goodtailor-plugin' ),
		'search_items'       => __( 'Search Services', 'goodtailor-plugin' ),
		'not_found'          => __( 'No Service found', 'goodtailor-plugin' ),
		'not_found_in_trash' => __( 'No Service found in Trash', 'goodtailor-plugin' ),
		'menu_name'          => __( 'Services', 'goodtailor-plugin' ),
		'parent_item'        => __( 'Parent Service', 'goodtailor-plugin' ),
		'parent_item_colon'  => __( 'Parent Service:', 'goodtailor-plugin' ),
	);
	$service_args = array(
		'labels'        => $service_labels,
		'public'        => true,
		'show_ui'       => true,
		'menu_icon'     => 'dashicons-clipboard',
		'menu_position' => 6,
		'hierarchical'  => true,
		'has_archive'   => false,
		'map_meta_cap'  => true,
		'supports'      => array( 'title', 'editor', 'excerpt', 'thumbnail', 'page-attributes' ),
	);
	register_post_type( 'service', $service_args );
	// Service Category taxonomy
	$service_category_labels = array(
		'name'                  => __( 'Service Categories', 'goodtailor-plugin' ),
		'singular_name'         => __( 'Service Category', 'goodtailor-plugin' ),
		'menu_name'             => __( 'Service Categories', 'goodtailor-plugin' ),
		'search_items'          => __( 'Search Service Categories', 'goodtailor-plugin' ),
		'all_items'             => __( 'All Service Categories', 'goodtailor-plugin' ),
		'edit_item'             => __( 'Edit Service Category', 'goodtailor-plugin' ),
		'update_item'           => __( 'Update Service Category', 'goodtailor-plugin' ),
		'add_new_item'          => __( 'Add new Service Category', 'goodtailor-plugin' ),
		'new_item_name'         => __( 'New Service Category', 'goodtailor-plugin' ),
		'choose_from_most_used' => __( 'Choose from the most used categories', 'goodtailor-plugin' ),
	);
	$service_category_args = array(
		'labels'            => $service_category_labels,
		'show_ui'           => true,
		'show_tagcloud'     => false,
		'show_admin_column' => true,
	);
	register_taxonomy( 'service_category', 'service', $service_category_args );
	// Service Tag taxonomy
	$service_tag_labels = array(
		'name'          => __( 'Service Tags', 'goodtailor-plugin' ),
		'singular_name' => __( 'Service Tag', 'goodtailor-plugin' ),
		'menu_name'     => __( 'Service Tags', 'goodtailor-plugin' ),
		'search_items'  => __( 'Search Service Tags', 'goodtailor-plugin' ),
		'all_items'     => __( 'All Service Tags', 'goodtailor-plugin' ),
		'edit_item'     => __( 'Edit Service Tag', 'goodtailor-plugin' ),
		'update_item'   => __( 'Update Service Tag', 'goodtailor-plugin' ),
		'add_new_item'  => __( 'Add new Service Tag', 'goodtailor-plugin' ),
		'new_item_name' => __( 'New Service Tag', 'goodtailor-plugin' ),
	);
	$service_tag_args = array(
		'labels'            => $service_tag_labels,
		'show_ui'           => true,
		'show_tagcloud'     => false,
		'show_admin_column' => true,
	);
	register_taxonomy( 'service_tag', 'service', $service_tag_args );

	// Testimonial
	$testimonial_labels = array(
		'name'               => __( 'Testimonials', 'goodtailor-plugin' ),
		'singular_name'      => __( 'Testimonial', 'goodtailor-plugin' ),
		'add_new'            => __( 'Add New', 'goodtailor-plugin' ),
		'add_new_item'       => __( 'Add New Testimonial', 'goodtailor-plugin' ),
		'edit_item'          => __( 'Edit Testimonial', 'goodtailor-plugin' ),
		'new_item'           => __( 'New Testimonial', 'goodtailor-plugin' ),
		'all_items'          => __( 'All Testimonials', 'goodtailor-plugin' ),
		'view_item'          => __( 'View Testimonial', 'goodtailor-plugin' ),
		'search_items'       => __( 'Search Testimonials', 'goodtailor-plugin' ),
		'not_found'          => __( 'No Testimonial found', 'goodtailor-plugin' ),
		'not_found_in_trash' => __( 'No Testimonial found in Trash', 'goodtailor-plugin' ),
		'menu_name'          => __( 'Testimonials', 'goodtailor-plugin' ),
		'parent_item'        => __( 'Parent Testimonial', 'goodtailor-plugin' ),
		'parent_item_colon'  => __( 'Parent Testimonial:', 'goodtailor-plugin' ),
	);
	$testimonial_args = array(
		'labels'              => $testimonial_labels,
		'public'              => true,
		'show_ui'             => true,
		'menu_icon'           => 'dashicons-format-quote',
		'menu_position'       => 6,
		'has_archive'         => false,
		'map_meta_cap'        => true,
		'supports'            => array( 'title', 'editor', 'thumbnail', 'page-attributes' ),
		'exclude_from_search' => true,
	);
	register_post_type( 'testimonial', $testimonial_args );
	// Testimonial Category taxonomy
	$testimonial_category_labels = array(
		'name'          => __( 'Testimonial Categories', 'goodtailor-plugin' ),
		'singular_name' => __( 'Testimonial Category', 'goodtailor-plugin' ),
		'menu_name'     => __( 'Testimonial Categories', 'goodtailor-plugin' ),
		'search_items'  => __( 'Testimonial Search categories', 'goodtailor-plugin' ),
		'all_items'     => __( 'All Testimonial Categories', 'goodtailor-plugin' ),
		'edit_item'     => __( 'Edit Testimonial Category', 'goodtailor-plugin' ),
		'update_item'   => __( 'Update Testimonial Category', 'goodtailor-plugin' ),
		'add_new_item'  => __( 'Add new Testimonial Category', 'goodtailor-plugin' ),
		'new_item_name' => __( 'New Testimonial Category', 'goodtailor-plugin' ),
	);
	$testimonial_category_args = array(
		'labels'            => $testimonial_category_labels,
		'show_ui'           => true,
		'show_tagcloud'     => false,
		'show_admin_column' => true,
	);
	register_taxonomy( 'testimonial_category', 'testimonial', $testimonial_category_args );
}
add_action( 'init', 'goodtailor_cpt_register_post_types' );

/**
 * Integrate with Carbon Fields plugin to add some useful custom fields meta boxes
 * for our custom post types
 */
function goodtailor_cpt_register_carbon_fields() {
	require_once GOODTAILOR_PLUGIN_DIR_PATH . 'carbon-fields/carbon-fields-config.php';
}
add_action( 'carbon_register_fields', 'goodtailor_cpt_register_carbon_fields' );

/**
 * Add the Featured Image column to the list of posts in the Dashboard
 */
function goodtailor_cpt_manage_posts_columns( $columns, $post_type ) {
	if ( 'product' === $post_type ) {
		return $columns;
	}
	$columns['featured-image'] = __( 'Featured Image', 'goodtailor-plugin' );
	return $columns;
}
add_filter( 'manage_posts_columns', 'goodtailor_cpt_manage_posts_columns', 10, 2 );

/**
 * Handle the rendering of the "Featured Image" column
 */
function goodtailor_cpt_render_featured_image_column( $column, $post_id ) {
	if ( 'featured-image' === $column ) {
		echo get_the_post_thumbnail( $post_id, array( 100, 100 ) );
	}
}
add_action( 'manage_pages_custom_column', 'goodtailor_cpt_render_featured_image_column', 10, 2 );
add_action( 'manage_posts_custom_column', 'goodtailor_cpt_render_featured_image_column', 10, 2 );

/**
 * Add the "Menu order" column to the list of Services and Testimonials in the admin dashboard
 */
function goodtailor_cpt_manage_edit_columns( $columns ) {
	$columns['menu_order'] = __( 'Menu order', 'goodtailor-plugin' );
	return $columns;
}
add_filter( 'manage_edit-service_columns', 'goodtailor_cpt_manage_edit_columns' );
add_filter( 'manage_edit-testimonial_columns', 'goodtailor_cpt_manage_edit_columns' );

/**
 * Make the "Menu order" column sortable
 */
function goodtailor_cpt_manage_edit_sortable_columns( $columns ) {
	$columns['menu_order'] = 'menu_order';
	return $columns;
}
add_filter( 'manage_edit-service_sortable_columns', 'goodtailor_cpt_manage_edit_sortable_columns' );
add_filter( 'manage_edit-testimonial_sortable_columns', 'goodtailor_cpt_manage_edit_sortable_columns' );

/**
 * Handle the rendering of the "Menu order" column
 */
function goodtailor_cpt_render_menu_order_column( $column, $post_id ) {
	if ( 'menu_order' === $column ) {
		echo esc_html( get_post( $post_id )->menu_order );
	}
}
add_action( 'manage_service_posts_custom_column', 'goodtailor_cpt_render_menu_order_column', 10, 2 );
add_action( 'manage_testimonial_posts_custom_column', 'goodtailor_cpt_render_menu_order_column', 10, 2 );
