<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_GoodTailor_CTA' ) ) {
	class WPBakeryShortCode_GoodTailor_CTA extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'goodtailor_cta',
	'html_template' => GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_cta/template.php',
	'name'          => __( 'Call To Action', 'goodtailor-plugin' ),
	'category'      => __( 'GoodTailor WP Theme', 'goodtailor-plugin' ),

	'params'        => array(
		array(
			'type'       => 'textarea_html',
			'param_name' => 'content',
			'holder'     => 'div',
			'heading'    => __( 'Text content', 'goodtailor-plugin' ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'style',
			'value'      => array(
				__( 'Vertical', 'goodtailor-plugin' )   => 'vertical',
				__( 'Horizontal', 'goodtailor-plugin' ) => 'horizontal',
			),
			'heading'    => __( 'Style', 'goodtailor-plugin' ),
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'button_text',
			'heading'    => __( 'Button Text', 'goodtailor-plugin' ),
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'button_href',
			'value'      => '#',
			'heading'    => __( 'Button Link', 'goodtailor-plugin' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'goodtailor-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'goodtailor-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'group'      => __( 'Design Options', 'goodtailor-plugin' ),
			'heading'    => __( 'CSS box', 'goodtailor-plugin' ),
		),
	),
);
