<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $style
 * @var $button_text
 * @var $button_href
 * @var $content
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class = 'call-to-act call-to-act--' . $style;
$class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );
?>

<div class="<?php echo esc_attr( $class ); ?>">
	<div class="call-to-act-copy-wrap">
		<?php echo wpb_js_remove_wpautop( $content, true ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</div>
	<div class="call-to-act-button-wrap">
		<a class="btn btn-primary btn-large btn-rounded" href="<?php echo esc_url( $button_href ); ?>"><?php echo esc_html( $button_text ); ?></a>
	</div>
</div>
