<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $style
 * @var $image_id
 * @var $icon_font
 * @var $content
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class = 'feature-box feature-box--' . $style;
$class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$icon_class = '';
if ( 'no' !== $icon_font ) {
	vc_icon_element_fonts_enqueue( $icon_font );
	$icon_class = isset( ${'icon_' . $icon_font} ) ? ${'icon_' . $icon_font} : '';
}
?>

<div class="<?php echo esc_attr( $class ); ?>">

	<?php if ( ! empty( $image_id ) && 'style-2' === $style ) : ?>
		<div class="feature-box-image-wrap">
			<?php echo wp_get_attachment_image( $image_id, 'medium_large', false, array( 'class' => 'feature-box-image' ) ); ?>
		</div>
	<?php endif; ?>

	<div class="feature-box-icon">
		<?php if ( ! empty( $icon_class ) ) : ?>
			<span class="<?php echo esc_attr( $icon_class ); ?>"></span>
		<?php endif; ?>
	</div>

	<div class="feature-box-copy-wrap">
		<?php echo wpb_js_remove_wpautop( $content, true ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</div>

</div>
