<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_GoodTailor_Pricing_Box' ) ) {
	class WPBakeryShortCode_GoodTailor_Pricing_Box extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'goodtailor_pricing_box',
	'html_template' => GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_pricing_box/template.php',
	'name'          => __( 'Pricing box', 'goodtailor-plugin' ),
	'category'      => __( 'GoodTailor WP Theme', 'goodtailor-plugin' ),

	'params'        => array(
		array(
			'type'       => 'dropdown',
			'param_name' => 'display_style',
			'heading'    => __( 'Display style', 'goodtailor-plugin' ),
			'value'      => array(
				__( 'Normal', 'goodtailor-plugin' )   => 'normal',
				__( 'Featured', 'goodtailor-plugin' ) => 'featured',
			),
		),
		array(
			'type'       => 'textarea_html',
			'param_name' => 'content',
			'holder'     => 'div',
			'heading'    => __( 'Content', 'goodtailor-plugin' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'goodtailor-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'goodtailor-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'group'      => __( 'Design Options', 'goodtailor-plugin' ),
			'heading'    => __( 'CSS box', 'goodtailor-plugin' ),
		),
	),
);
