<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_GoodTailor_Services_Carousel' ) ) {
	class WPBakeryShortCode_GoodTailor_Services_Carousel extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'goodtailor_services_carousel',
	'html_template' => GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_services_carousel/template.php',
	'name'          => __( 'Services Carousel', 'goodtailor-plugin' ),
	'category'      => __( 'GoodTailor WP Theme', 'goodtailor-plugin' ),

	'params'        => array(
		array(
			'type'       => 'dropdown',
			'param_name' => 'display_style',
			'heading'    => __( 'Display style', 'goodtailor-plugin' ),
			'value'      => array(
				__( 'Card shaped items / 3 columns', 'goodtailor-plugin' ) => 'columns-3',
				__( 'Card shaped items / 4 columns', 'goodtailor-plugin' ) => 'columns-4',
				__( 'Star shaped items / 3 columns', 'goodtailor-plugin' ) => 'star-columns-3',
			),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'service_tag',
			'heading'    => __( 'Show services with tag', 'goodtailor-plugin' ),
			'value'      => goodtailor_vc_get_taxonomy_terms( 'service_tag', array( 'All' => '' ) ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'posts_per_page',
			'value'       => 6,
			'heading'     => __( 'Number of items to show', 'goodtailor-plugin' ),
			'description' => __( 'To show all items enter: All', 'goodtailor-plugin' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'goodtailor-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'goodtailor-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'goodtailor-plugin' ),
			'group'      => __( 'Design Options', 'goodtailor-plugin' ),
		),
	),
);
