<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $display_style
 * @var $posts_per_page
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$carousel_class = 'services-carousel bt-carousel js-bt-carousel owl-carousel';
$carousel_class .= vc_shortcode_custom_css_class( $atts['css'], ' ' ) . $this->getExtraClass( $atts['el_class'] );
$carousel_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $carousel_class, $this->settings['base'], $atts );

$tax_query = null;
if ( $service_tag ) {
	$tax_query = array(
		array(
			'taxonomy' => 'service_tag',
			'field'    => 'slug',
			'terms'    => $service_tag,
		),
	);
}
$query = new WP_Query( array(
	'post_type'      => 'service',
	'posts_per_page' => 'All' === $posts_per_page ? -1 : (int) $posts_per_page,
	'tax_query'      => $tax_query,
	'orderby'        => array(
		'menu_order' => 'ASC',
		'date'       => 'DESC',
	),
) );

$items_per_slide = ( 'columns-4' === $display_style ? 4 : 3 );

?>

<?php if ( ! $query->have_posts() ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'No items', 'goodtailor-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please add some Services items to show.', 'goodtailor-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $carousel_class ); ?>" data-items="<?php echo esc_attr( $items_per_slide ); ?>" data-equal-heights>

		<?php while ( $query->have_posts() ) : $query->the_post(); ?>

			<?php if ( 'star-columns-3' === $display_style ) : ?>

				<div class="service-star">
					<a href="<?php the_permalink(); ?>" rel="bookmark">

						<?php $image_url = get_the_post_thumbnail_url( null, 'medium_large' ); ?>
						<svg class="service-star-svg">
							<g class="service-star-clip-path" clip-path="url(#star-clip-path)">
								<image class="service-star-svg-image" width="100%" height="100%" xlink:href="<?php echo esc_attr( $image_url ); ?>" preserveAspectRatio="xMidYMid slice" />
							</g>
						</svg>

						<h4 class="service-star-title"><?php the_title(); ?></h4>

					</a>
				</div>

			<?php else : ?>

				<div class="service-card">
					<a href="<?php the_permalink(); ?>" rel="bookmark">
						<div class="service-card-image"><?php the_post_thumbnail( 'medium_large' ); ?></div>
						<h4 class="service-card-title"><?php the_title(); ?></h4>
					</a>
				</div>

			<?php endif; ?>

		<?php endwhile; ?>

		<?php wp_reset_postdata(); ?>

	</div>

<?php endif; ?>
