<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $display_style
 * @var $posts_per_page
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class = 'testimonials-carousel bt-carousel js-bt-carousel owl-carousel';
$class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$query = new WP_Query( array(
	'post_type'      => 'testimonial',
	'posts_per_page' => 'All' === $posts_per_page ? -1 : (int) $posts_per_page,
	'orderby'        => array(
		'menu_order' => 'ASC',
		'date'       => 'DESC',
	),
) );

$items_per_slide = ( 'style-2' === $display_style ? 2 : 1 );

?>

<?php if ( ! $query->have_posts() ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'No items', 'goodtailor-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please add some Testimonials items to show.', 'goodtailor-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $class ); ?>" data-items="<?php echo esc_attr( $items_per_slide ); ?>" data-equal-heights>

		<?php while ( $query->have_posts() ) : $query->the_post(); ?>

			<blockquote class="testimonial-item">

				<div class="testimonial-item-text"><?php the_content(); ?></div>

				<footer>

					<div class="testimonial-item-image"><?php the_post_thumbnail( 'thumbnail' ); ?></div>

					<span class="testimonial-item-author"><?php the_title(); ?></span>

					<?php
					$subtitle = get_post_meta( get_the_ID(), '_goodtailor_author_subtitle', true );
					if ( $subtitle ) :
						?>
						<span class="testimonial-item-author-subtitle"><?php echo esc_html( $subtitle ); ?></span>
					<?php endif; ?>

				</footer>

			</blockquote>

		<?php endwhile; ?>

		<?php wp_reset_postdata(); ?>

	</div>

<?php endif; ?>
