<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $display_style
 * @var $image_id
 * @var $content
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class = 'text-image-block';
if ( 'image-right' === $display_style ) {
	$class .= ' text-image-block--image-right';
}
$class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );
?>

<div class="<?php echo esc_attr( $class ); ?>">

	<div class="text-image-block-image">
		<?php
		if ( ! empty( $image_id ) ) {
			echo wp_get_attachment_image( $image_id, 'full' );
		}
		?>
	</div>

	<div class="text-image-block-text">
		<?php echo wpb_js_remove_wpautop( $content ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</div>

</div>
