<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class = 'three-recent-posts';
$class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$query = new WP_Query( array(
	'post_type'           => 'post',
	'posts_per_page'      => 3,
	'ignore_sticky_posts' => true,
) );

?>

<?php if ( ! $query->have_posts() ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'No items', 'goodtailor-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please add some Posts to show.', 'goodtailor-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $class ); ?>">

		<?php
		$item_index = 0;
		while ( $query->have_posts() ) : $query->the_post();
			$item_index++;
			?>

			<div class="three-recent-posts-column">

				<article id="post-<?php the_ID(); ?>" <?php post_class( 'article-card' ); ?>>

					<a href="<?php the_permalink(); ?>" rel="bookmark">
						<div class="article-card-image">
							<?php the_post_thumbnail( ( 1 === $item_index ? 'large' : 'medium_large' ) ); ?>
						</div>
					</a>

					<div class="article-card-copy">

						<a href="<?php the_permalink(); ?>" rel="bookmark">
							<h2 class="article-card-title" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></h2>
							<div class="article-card-text"><?php the_excerpt(); ?></div>
						</a>

						<footer class="article-card-meta">

							<a href="<?php the_permalink(); ?>" rel="bookmark">
								<time datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>"><?php echo esc_html( get_the_date() ); ?></time>
							</a>

							<?php
							$comments_number = get_comments_number();
							if ( $comments_number ) :
								?>
								<span class="article-card-meta-separator">&bull;</span>
								<a href="<?php comments_link(); ?>">
									<?php
									/* translators: %d is the number of comments */
									printf( esc_html( _n( '%d comment', '%d comments', $comments_number, 'goodtailor-plugin' ) ), esc_html( $comments_number ) );
									?>
								</a>
							<?php endif; ?>

						</footer>

					</div>

				</article>

			</div>

		<?php endwhile; ?>

	</div>

	<?php wp_reset_postdata(); ?>

<?php endif; ?>
