<?php
/*
Plugin Name: GoodTailor Custom Post Types and Shortcodes
Description: This plugin adds custom post types and shortcodes used by GoodTailor WP Theme.
Version: 1.5.8
Text Domain: goodtailor-plugin
Domain Path: /languages/
License: GPLv2
*/

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

define( 'GOODTAILOR_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
define( 'GOODTAILOR_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );

/**
 * Plugin activation
 */
function goodtailor_plugin_install() {
	goodtailor_cpt_register_post_types();
	flush_rewrite_rules();
}
register_activation_hook( __FILE__, 'goodtailor_plugin_install' );

/**
 * Plugin deactivation
 */
function goodtailor_plugin_uninstall() {
	flush_rewrite_rules();
}
register_deactivation_hook( __FILE__, 'goodtailor_plugin_uninstall' );

/**
 * Load the plugin textdomain to allow localization
 */
function goodtailor_plugin_load_text_domain() {
	load_plugin_textdomain( 'goodtailor-plugin', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
add_action( 'init', 'goodtailor_plugin_load_text_domain' );

/**
 * Custom post types
 */
require GOODTAILOR_PLUGIN_DIR_PATH . 'custom-post-types.php';

/**
 * Visual Composer Add-on
 */
require GOODTAILOR_PLUGIN_DIR_PATH . 'visual-composer/vc-addon.php';
