<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_GoodTailor_Section_Heading' ) ) {
	class WPBakeryShortCode_GoodTailor_Section_Heading extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'goodtailor_section_heading',
	'html_template' => GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_section_heading/template.php',
	'name'          => __( 'Section Heading', 'goodtailor-plugin' ),
	'category'      => __( 'GoodTailor WP Theme', 'goodtailor-plugin' ),

	'params'        => array(
		array(
			'type'       => 'dropdown',
			'param_name' => 'decoration',
			'heading'    => __( 'Decoration', 'goodtailor-plugin' ),
			'value'      => array(
				__( 'No decoration', 'goodtailor-plugin' ) => 'no',
				__( 'Style 1', 'goodtailor-plugin' )       => 'decor-1',
			),
		),
		array(
			'type'       => 'textarea_html',
			'param_name' => 'content',
			'holder'     => 'div',
			'heading'    => __( 'Text', 'goodtailor-plugin' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'goodtailor-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'goodtailor-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'goodtailor-plugin' ),
			'group'      => __( 'Design Options', 'goodtailor-plugin' ),
		),
	),
);
