<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $display_style
 * @var $posts_per_page
 * @var $show_category_filter
 * @var $default_filter_text
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$grid_class = 'services-grid bt-grid';
if ( 'star-columns-3' === $display_style ) {
	$grid_class .= ' services-grid--stars';
}
if ( 'columns-4' === $display_style ) {
	$grid_class .= ' bt-grid--columns-4';
}
if ( 'yes' === $show_category_filter ) {
	$grid_class .= ' js-bt-grid';
}
$grid_class .= vc_shortcode_custom_css_class( $atts['css'], ' ' ) . $this->getExtraClass( $atts['el_class'] );
$grid_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $grid_class, $this->settings['base'], $atts );

$tax_query = null;
if ( $service_tag ) {
	$tax_query = array(
		array(
			'taxonomy' => 'service_tag',
			'field'    => 'slug',
			'terms'    => $service_tag,
		),
	);
}
$query = new WP_Query( array(
	'post_type'      => 'service',
	'posts_per_page' => 'All' === $posts_per_page ? -1 : (int) $posts_per_page,
	'tax_query'      => $tax_query,
	'orderby'        => array(
		'menu_order' => 'ASC',
		'date'       => 'DESC',
	),
) );

$all_categories = false;
if ( 'yes' === $show_category_filter ) {
	$all_categories = array();
	if ( $query->have_posts() ) {
		while ( $query->have_posts() ) {
			$query->the_post();
			$categories = goodtailor_vc_get_the_terms( get_post(), 'service_category' );
			if ( ! is_wp_error( $categories ) && ! empty( $categories ) ) {
				$all_categories = array_merge( $all_categories, $categories );
			}
		}
		$query->rewind_posts();
	}
	if ( ! empty( $all_categories ) ) {
		$all_categories = array_unique( $all_categories );
		sort( $all_categories );
	}
}

?>

<?php if ( ! $query->have_posts() ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'No items', 'goodtailor-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please add some Services items to show.', 'goodtailor-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $grid_class ); ?>">

		<?php if ( $all_categories ) : ?>
			<div class="bt-grid-filters-container">

				<span class="bt-grid-filters-title"><?php esc_html_e( 'Category: ', 'goodtailor-plugin' ); ?></span>

				<button class="bt-grid-filter is-active" data-group="all"><?php echo esc_html( $default_filter_text ); ?></button>

				<?php foreach ( $all_categories as $category ) : ?>
					<button class="bt-grid-filter" data-group="<?php echo esc_attr( $category ); ?>"><?php echo esc_html( $category ); ?></button>
				<?php endforeach; ?>

			</div>
		<?php endif; ?>

		<div class="bt-grid-items-container">

			<?php
			while ( $query->have_posts() ) : $query->the_post();
				$categories = false;
				if ( 'yes' === $show_category_filter ) {
					$categories = goodtailor_vc_get_the_terms( get_post(), 'service_category' );
					if ( ! empty( $categories ) ) {
						$categories = '["' . join( '","', $categories ) . '"]';
					} else {
						$categories = '[]';
					}
				}
				?>

				<div class="bt-grid-item" <?php if ( $categories ) { echo 'data-groups="' . esc_attr( $categories ) . '"'; } ?>>

					<?php if ( 'star-columns-3' === $display_style ) : ?>

						<div class="service-star">
							<a href="<?php the_permalink(); ?>" rel="bookmark">

								<?php $image_url = get_the_post_thumbnail_url( null, 'medium_large' ); ?>
								<svg class="service-star-svg">
									<g class="service-star-clip-path" clip-path="url(#star-clip-path)">
										<image class="service-star-svg-image" width="100%" height="100%" xlink:href="<?php echo esc_attr( $image_url ); ?>" preserveAspectRatio="xMidYMid slice" />
									</g>
								</svg>

								<h4 class="service-star-title"><?php the_title(); ?></h4>

							</a>
						</div>

					<?php else : ?>

						<div class="service-card">
							<a href="<?php the_permalink(); ?>" rel="bookmark">
								<div class="service-card-image"><?php the_post_thumbnail( 'medium_large' ); ?></div>
								<h4 class="service-card-title"><?php the_title(); ?></h4>
							</a>
						</div>

					<?php endif; ?>

				</div>

			<?php endwhile; ?>

			<?php wp_reset_postdata(); ?>

		</div>

	</div>

<?php endif; ?>
