<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_GoodTailor_Testimonials_Carousel' ) ) {
	class WPBakeryShortCode_GoodTailor_Testimonials_Carousel extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'goodtailor_testimonials_carousel',
	'html_template' => GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_testimonials_carousel/template.php',
	'name'          => __( 'Testimonials Carousel', 'goodtailor-plugin' ),
	'category'      => __( 'GoodTailor WP Theme', 'goodtailor-plugin' ),

	'params'        => array(
		array(
			'type'       => 'dropdown',
			'param_name' => 'display_style',
			'heading'    => __( 'Display style', 'goodtailor-plugin' ),
			'value'      => array(
				__( '1 testimonial per slide', 'goodtailor-plugin' )  => 'style-1',
				__( '2 testimonials per slide', 'goodtailor-plugin' ) => 'style-2',
			),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'posts_per_page',
			'value'       => 6,
			'heading'     => __( 'Number of items to show', 'goodtailor-plugin' ),
			'description' => __( 'To show all items enter: All', 'goodtailor-plugin' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'goodtailor-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'goodtailor-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'goodtailor-plugin' ),
			'group'      => __( 'Design Options', 'goodtailor-plugin' ),
		),
	),
);
