<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_GoodTailor_Text_Image' ) ) {
	class WPBakeryShortCode_GoodTailor_Text_Image extends WPBakeryShortCodesContainer {
	}
}

return array(
	'base'          => 'goodtailor_text_image',
	'html_template' => GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_text_image/template.php',
	'is_container'  => true,
	'js_view'       => 'VcColumnView',
	'name'          => __( 'Text + Image', 'goodtailor-plugin' ),
	'category'      => __( 'GoodTailor WP Theme', 'goodtailor-plugin' ),

	'params'        => array(
		array(
			'type'       => 'dropdown',
			'param_name' => 'display_style',
			'heading'    => __( 'Display style', 'goodtailor-plugin' ),
			'value'      => array(
				__( 'Image Left', 'goodtailor-plugin' )  => 'image-left',
				__( 'Image Right', 'goodtailor-plugin' ) => 'image-right',
			),
		),
		array(
			'type'       => 'attach_image',
			'param_name' => 'image_id',
			'heading'    => __( 'Image', 'goodtailor-plugin' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'goodtailor-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'goodtailor-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'goodtailor-plugin' ),
			'group'      => __( 'Design Options', 'goodtailor-plugin' ),
		),
	),
);
