<?php
/**
 * Extensions for WPBakery Visual Composer plugin
 *
 * @package GoodTailor_Plugin
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

define( 'GOODTAILOR_VC_ADDON_PATH', GOODTAILOR_PLUGIN_DIR_PATH . 'visual-composer/' );
define( 'GOODTAILOR_VC_SHORTCODES_PATH', GOODTAILOR_PLUGIN_DIR_PATH . 'visual-composer/shortcodes/' );

/**
 * Register custom VC shortcodes
 */
function goodtailor_vc_map_shortcodes() {
	vc_lean_map( 'goodtailor_cta', null, GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_cta/config.php' );
	vc_lean_map( 'goodtailor_feature_box', null, GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_feature_box/config.php' );
	vc_lean_map( 'goodtailor_logo_box', null, GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_logo_box/config.php' );
	vc_lean_map( 'goodtailor_pricing_box', null, GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_pricing_box/config.php' );
	vc_lean_map( 'goodtailor_section_heading', null, GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_section_heading/config.php' );
	vc_lean_map( 'goodtailor_services_carousel', null, GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_services_carousel/config.php' );
	vc_lean_map( 'goodtailor_services_grid', null, GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_services_grid/config.php' );
	vc_lean_map( 'goodtailor_testimonials_carousel', null, GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_testimonials_carousel/config.php' );
	vc_lean_map( 'goodtailor_text_image', null, GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_text_image/config.php' );
	vc_lean_map( 'goodtailor_three_recent_posts', null, GOODTAILOR_VC_SHORTCODES_PATH . 'goodtailor_three_recent_posts/config.php' );
}

if ( function_exists( 'vc_lean_map' ) ) {
	// If we can perform the mapping on this stage, then do it.
	goodtailor_vc_map_shortcodes();
} else {
	// Otherwise hook to VC initializiation.
	add_action( 'vc_after_init', 'goodtailor_vc_map_shortcodes' );
}

/**
 * Register image sizes that are used in our custom shortcodes
 */
function goodtailor_vc_register_image_sizes() {
	add_image_size( 'goodtailor_vc_logos', 230, 180 );
}
add_action( 'init', 'goodtailor_vc_register_image_sizes' );

/**
 * Register Themify icons CSS
 */
function goodtailor_vc_register_themify_icons_style() {
	wp_register_style( 'goodtailor_vc_themify-icons', GOODTAILOR_PLUGIN_DIR_URL . 'assets/css/themify-icons.min.css', false, '1.0.1' );
}
add_action( 'wp_enqueue_scripts', 'goodtailor_vc_register_themify_icons_style' );
add_action( 'admin_enqueue_scripts', 'goodtailor_vc_register_themify_icons_style' );

/**
 * Enqueue Themify icons CSS if necessary
 */
function goodtailor_vc_enqueue_themify_icons_style( $font ) {
	if ( 'themify' === $font && apply_filters( 'goodtailor_vc_enqueue_themify_icons_css', true ) ) {
		wp_enqueue_style( 'goodtailor_vc_themify-icons' );
	}
}
add_action( 'vc_enqueue_font_icon_element', 'goodtailor_vc_enqueue_themify_icons_style' );

/**
 * Always enqueue Themify icons CSS when inside VC editor mode
 */
function goodtailor_vc_editor_enqueue_themify_icons_style() {
	wp_enqueue_style( 'goodtailor_vc_themify-icons' );
}
add_action( 'vc_backend_editor_enqueue_js_css', 'goodtailor_vc_editor_enqueue_themify_icons_style' );
add_action( 'vc_frontend_editor_enqueue_js_css', 'goodtailor_vc_editor_enqueue_themify_icons_style' );

/**
 * Add Themify icons list to VC icon picker
 */
function goodtailor_vc_iconpicker_type_themify( $icons ) {
	$themify = require GOODTAILOR_VC_ADDON_PATH . 'vc-themify-icons-config.php';
	return array_merge( $icons, $themify );
}
add_filter( 'vc_iconpicker-type-themify', 'goodtailor_vc_iconpicker_type_themify' );

/**
 * VC Helper functions
 */
require GOODTAILOR_VC_ADDON_PATH . 'vc-functions.php';
