<?php

use WPGDPRC\Utils\Elements;
use WPGDPRC\Utils\Template;

/**
 * @var string $class
 * @var string $title_class
 * @var string $title
 * @var string $text
 * @var string $link_title
 * @var string $link_url
 * @var string $link_attributes
 */

$link_class = strpos($class, '--primary') ? 'wpgdprc-link--white' : '';
$footer     = '';
if( !empty($link_title) && !empty($link_url) ) {
    $footer = Elements::getLink(
        $link_url,
        Template::getIcon(!empty($link_class) ? 'arrow-right' : 'cog') . $link_title,
        array_merge([ 'class' => implode(' ', [ 'wpgdprc-tile__link', 'wpgdprc-link', esc_attr($link_class) ]) ], $link_attributes),
        true
    );
}

Template::render('Admin/tile', [
    'class'       => $class,
    'heading'     => 3,
    'title_class' => $title_class,
    'title'       => $title,
    'text'        => $text,
    'footer'      => $footer,
]);
