<?php

use WPGDPRC\Utils\AdminForm;
use WPGDPRC\Utils\Elements;
use WPGDPRC\WordPress\Admin\Pages\PageDashboard;
use WPGDPRC\WordPress\Config;
use WPGDPRC\WordPress\Plugin;
use WPGDPRC\WordPress\Settings;

/**
 * @var string $current
 * @var string $title
 * @var string $intro
 */

?>

<form method="post" action="<?php echo PageDashboard::getFormAction( $current ); ?>">
    <input type="hidden" name="tab" value="<?php echo $current; ?>"/>
    <div class="grid-x grid-margin-x grid-margin-y">
        <header class="wpgdprc-content__header cell large-7">
            <h2 class="wpgdprc-content__title"><?php echo $title; ?></h2>
        </header>
        <div class="cell large-5">
            <div class="wpgdprc-form__field--pluginmode textright">
				<?php
				AdminForm::renderSettingField( 'truefalse', _x( 'Enable business mode', 'admin', 'wp-gdpr-compliance' ), Settings::KEY_PREMIUM, [
					'value' => Settings::isPremium() ? '1' : '0',
					'class' => 'regular-text',
				], false );
				?>
            </div>
        </div>
        <div class="cell large-12">
            <div class="wpgdprc-content__text">
                <h3 class="wpgdprc-content__title h4">
					<?php echo _x( 'Upgrade today and unlock fully automatic GDPR compliance', 'admin', 'wp-gdpr-compliance' ); ?>
                </h3>
				<?php echo implode( '<br><br>', [
					sprintf( "<strong>%s</strong>", _x( 'Eliminate the risk of being fined by demonstrating full compliance with local and global data privacy guidelines and regulations.', 'admin', 'wp-gdpr-compliance' ) ),
					_x( 'Automatically update consent texts in more than 40 languages based on frequent scans of your website.', 'admin', 'wp-gdpr-compliance' ),
					_x( 'Get an intuitive and fully customizable consent pop-up that is good for SEO, allows you to follow GDPR and Google’s and Facebook’s terms of service, which now require you to have a GDPR compliant consent pop-up.', 'admin', 'wp-gdpr-compliance' ),
					_x( 'Fill your marketing funnel with compliant data, with integrations to Google Ads, Analytics, and Tag Manager, gaining insights into customer journeys without compromising user trust.', 'admin', 'wp-gdpr-compliance' ),
					_x( 'Put your visitors in control of their data to generate valuable trust and align with good data ethics while staying compliant.', 'admin', 'wp-gdpr-compliance' ),
					_x( 'Top security, hosted in EU and 99,95% uptime.', 'admin', 'wp-gdpr-compliance' ),
				] ); ?>
                <p>
                    <br>
					<?php Elements::link( Config::premiumUrl(), _x( 'Get started for free', 'admin', 'wp-gdpr-compliance' ), [
						'target' => '_blank',
						'class'  => 'wpgdprc-button wpgdprc-button--small'
					] ); ?>
                </p>
            </div>

        </div>
    </div>
</form>
