<?php

use WPGDPRC\Objects\DataProcessor;
use WPGDPRC\Utils\AdminForm;
use WPGDPRC\Utils\Elements;
use WPGDPRC\Utils\Template;
use WPGDPRC\WordPress\Admin\Pages\PageDashboard;
use WPGDPRC\WordPress\Admin\Pages\PageSettings;
use WPGDPRC\WordPress\Plugin;

/**
 * @var string $current
 */

$prefix  = !empty($current) ? $current : PageDashboard::TAB_PROCESSORS;
$active  = DataProcessor::isActive();
$status  = $active ? _x('active', 'admin', 'wp-gdpr-compliance') : _x('not active', 'admin', 'wp-gdpr-compliance');
$default = [
    'class'       => 'wpgdprc-tile--text',
    'heading'     => 4,
    'title_class' => 'h6',
];
$tiles   = [
    [
        'class'  => 'wpgdprc-tile--text wpgdprc-tile--consent-bar ' . ($active ? 'wpgdprc-tile--green-light' : ''),
        'title'  => _x('Consent bar', 'admin', 'wp-gdpr-compliance'),
        'text'   => sprintf(_x('The consent bar is %1s', 'admin', 'wp-gdpr-compliance'), '<strong>' . $status . '</strong>'),
        'extra'  => '<div class="wpgdprc-tile__check '.($active ? '' : 'hide').'">' . AdminForm::getField('truefalse', _x('Toggle consent bar', 'admin', 'wp-gdpr-compliance'), $prefix . '[active]', $active, [ 'border' => true, 'no_margin_right' => true, 'data-enable' => $active ? '1' : '0' ], true) . '</div>',
        'footer' => '<p class="wpgdprc-tile__message">' . ($active ? _x('You can disable the consent bar, this means that all data processors are deactivated.', 'admin', 'wp-gdpr-compliance') : _x('To enable the consent bar, activate one (or more) data processor(s).', 'admin', 'wp-gdpr-compliance')) . '</p>',
    ],
    [
        'title'  => _x('Reset consent bar', 'admin', 'wp-gdpr-compliance'),
        'text'   => _x('Want to reset the consent bar? This means that the consent bar will appear again for all users.', 'admin', 'wp-gdpr-compliance'),
        'footer' => Elements::getButton(
            _x('Reset', 'admin', 'wp-gdpr-compliance') . Template::getIcon('sync'),
            [ 'class' => 'wpgdprc-button wpgdprc-button--icon wpgdprc-button--white wpgdprc-button--small', 'data-action' => 'reset-consent' ]
        ),
    ],
    [
        'title'  => _x('Change the look', 'admin', 'wp-gdpr-compliance'),
        'text'   => _x('Change the colors of the consent bar and the settings.', 'admin', 'wp-gdpr-compliance'),
        'footer' => Elements::getLink(
            PageSettings::getSectionUrl(PageSettings::SECTION_CONSENT),
            _x('Change settings', 'admin', 'wp-gdpr-compliance'),
            [ 'class' => 'wpgdprc-button wpgdprc-button--white wpgdprc-button--small' ]
        ),
    ],
];

?>

<section class="wpgdprc-tiles">
	<div class="wpgdprc-tiles__header">
		<h3 class="wpgdprc-tiles__title h3"><?php _ex('Settings', 'admin', 'wp-gdpr-compliance'); ?></h3>
	</div>
	<div class="wpgdprc-tiles__container">
        <div class="grid-x grid-margin-x grid-margin-y">
            <?php foreach( $tiles as $tile ) : ?>
                <div class="cell large-6 xlarge-4">
                    <?php Template::render('Admin/tile', array_merge($default, $tile)); ?>
                </div>
            <?php endforeach; ?>
        </div>
	</div>
</section>
