<?php

use WPGDPRC\WordPress\Config;
use WPGDPRC\Utils\Elements;
use WPGDPRC\Utils\AdminForm;

?>

<div data-action="disable" data-title="<?php _ex( 'Cookie Information', 'admin', 'wp-gdpr-compliance' ); ?>" class="step">
    <h1 class="h2 step__title">
		<?php _ex( 'Sign up for Cookie Information', 'admin', 'wp-gdpr-compliance' ); ?>
    </h1>

    <p>
	    <?php _ex('Data privacy regulations have become much stricter. Upgrade your WP GDPR Compliance plugin to Business and secure your website’s GDPR cookie compliance.', 'admin', 'wp-gdpr-compliance'); ?>
    </p>

	<?php _ex(' Features include:', 'admin', 'wp-gdpr-compliance'); ?>
    <ul class="list">
        <li>
			<?php _ex('Customizable consent pop-ups', 'admin', 'wp-gdpr-compliance'); ?>
        </li>
        <li>
	        <?php _ex('Automated cookie policies', 'admin', 'wp-gdpr-compliance'); ?>
        </li>
        <li>
	        <?php _ex('Integration to Google Products', 'admin', 'wp-gdpr-compliance'); ?>
        </li>
        <li>
	        <?php _ex('And much more!', 'admin', 'wp-gdpr-compliance'); ?>
        </li>
    </ul>

    <div class="questionnaire margin-top-2">
        <p class="margin-bottom-0"><?= _x( 'How are you planning to use this plugin?', 'admin', 'wp-gdpr-c' ); ?></p>
        <div class="flex-container flex-dir-row-reverse align-right align-middle">
		    <?php
		    AdminForm::renderField( 'radio', _x( 'For a business website', 'admin', 'wp-gdpr-compliance' ), 'user_type', 'business', [
			    'required' => 'required',
			    'id'       => 'business',
		    ], false );
		    ?>
        </div>
        <div class="flex-container flex-dir-row-reverse align-right align-middle">
			<?php
                AdminForm::renderField( 'radio', _x( 'For my personal website', 'admin', 'wp-gdpr-compliance' ), 'user_type', 'personal', [
                    'required' => 'required',
                    'id'       => 'personal',
                ], false );
			?>
        </div>


        <div id="signup" class="margin-top-2 hide">
            <p data-for="business"><?= _x( 'Great! We recommend upgrading to the business version of Cookie Information for the best GDPR compliance possible, especially when operating within the EU.', 'admin', 'wp-gdpr-c' ); ?></p>
            <p data-for="personal"><?= _x( 'Awesome! For personal use it might be worth it to upgrade. Dont hesitate to check out the business features. There is a 30 day free trial to get you started!', 'admin', 'wp-gdpr-c' ); ?></p>
	        <?php Elements::link(Config::premiumUrl(), _x('Sign up for Cookie Information', 'admin', 'wp-gdpr-compliance' ), [ 'target' => '_blank', 'class' => 'wpgdprc-button button', 'id' => 'signuplink']); ?>
        </div>
    </div>
</div>
