<?php

use WPGDPRC\Utils\Elements;
use WPGDPRC\Utils\Helper;
use WPGDPRC\Utils\Wizard;
use WPGDPRC\WordPress\Admin\Pages\PageDashboard;
use WPGDPRC\WordPress\Admin\Pages\PageSettings;
use WPGDPRC\WordPress\Plugin;

?>

<div data-title="<?php _ex('Done', 'admin', 'wp-gdpr-compliance'); ?>" class="step">
	<h2 class="h2 step__title">
		<?php _ex("That's it!", 'admin', 'wp-gdpr-compliance'); ?>
	</h2>
	<p><?php _ex("That's it, we're done. We just setup your site and now you are more compliant already. Next steps are to check if all your consents are setup and check your pages.", 'admin', 'wp-gdpr-compliance'); ?></p>
	<ul class="no-bullet margin-0 margin-top-2">
		<li class="margin-bottom-1">
			<?php Elements::link(Wizard::getFinishLink(PageDashboard::getTabUrl(PageDashboard::TAB_PROCESSORS)), _x('Add a new consent', 'admin', 'wp-gdpr-compliance')); ?>
		</li>
		<li class="margin-bottom-1">
			<?php Elements::link(Wizard::getFinishLink(PageSettings::getSectionUrl(PageSettings::SECTION_CONSENT)), _x('Style your consent bar', 'admin', 'wp-gdpr-compliance')); ?>
		</li>
		<li>
			<?php Elements::link(Wizard::getFinishLink(PageSettings::getSectionUrl(PageSettings::SECTION_PRIVACY)), _x('Manage your Privacy Policy page', 'admin', 'wp-gdpr-compliance')); ?>
		</li>
	</ul>
</div>
