<?php

use WPGDPRC\Utils\Elements;
use WPGDPRC\Utils\Helper;
use WPGDPRC\Utils\Template;
use WPGDPRC\WordPress\Config;
use WPGDPRC\WordPress\Plugin;

$plugin_data = Helper::getPluginData();

?>

<div data-title="<?php _ex('Welcome', 'admin', 'wp-gdpr-compliance'); ?>" class="step">
	<h1 class="h2 step__title">
		<?php _ex('Welcome to Cookie Information', 'admin', 'wp-gdpr-compliance'); ?>
		<span><?php printf('v%1s', $plugin_data['Version']); ?></span>
	</h1>
	<p><?php _ex('Thank you very much for choosing this plugin to help you with your GDPR Compliance. In this wizard we help you to setup the plugin so you can quickly start with making your website more compliant.', 'admin', 'wp-gdpr-compliance'); ?></p>

	<div class="text-with-icon">
		<div class="text-with-icon__icon">
			<?php Template::renderSvg( 'icon-sparkles.svg' ); ?>
		</div>
		<div class="text-with-icon__text">
			<h2 class="h3 text-with-icon__title">
				<?php _ex('We have some news to share', 'admin', 'wp-gdpr-compliance'); ?>
			</h2>
			<p>
				<?php echo implode('<br><br>', [
					_x('We are happy to announce that WP GDPR Compliance has been acquired by the leading Consent Management Platform, Cookie Information. This will create tremendous benefits for all of the more than 200.000 websites using this plugin.', 'admin', 'wp-gdpr-compliance'),
					_x('You will get free upgrades to this plugin, and we will also expand the plugin with features targeted to business users that allow you to easier comply with GDPR. Planned features include cookie scanning, language support for 40+ languages, and much more. If you want to get a taste of what you can expect, you can try the full suite of Cookie Information for 30 days free and without a credit card.', 'admin', 'wp-gdpr-compliance'),
				]); ?>
			</p>
			<strong>
				<?php Elements::link(Config::premiumUrl(), _x('Try Cookie Information', 'admin', 'wp-gdpr-compliance'), [ 'target' => '_blank' ]); ?>
			</strong>
		</div>
	</div>
</div>
