<?php

use WPGDPRC\Utils\Template;

?>

<div class="wpgdprc wpgdprc-sign-up-modal modal" id="wpgdprc-sign-up-modal" aria-hidden="true">
    <div class="wpgdprc-sign-up-modal__overlay" tabindex="-1" data-signup-close>
        <div class="wpgdprc-sign-up-modal__inner" role="dialog" aria-modal="true">
            <div class="wpgdprc-sign-up-modal__header">
                <p class="wpgdprc-sign-up-modal__title"><?php
                    echo _x('Sign up for Cookie information', 'admin', 'wp-gdpr-compliance'); ?></p>
                <button class="wpgdprc-sign-up-modal__close" aria-label="<?php
                _e('Close popup', 'wp-gdpr-compliance'); ?>" data-signup-close>
                    <?php
                    Template::renderSvg('icon-fal-times.svg'); ?>
                </button>
                <button class="wpgdprc-sign-up-modal__back" aria-label="<?php
                _e('Back', 'wp-gdpr-compliance'); ?>">
                    <?php
                    Template::renderIcon('arrow-left','fontawesome-pro-regular'); ?>
                </button>
            </div>

            <div class="wpgdprc-sign-up-modal__step wpgdprc-sign-up-modal__choose-type">
                <p><?= _x(
                        'GDPR requrirements are different based on who you are. Please chose below and we will make sure you comply to GDPR.',
                        'admin',
                        'wp-gdpr-compliance'
                    ) ?></p>
                <div class="wpgdprc-sign-up-modal__columns">
                    <div class="wpgdprc-sign-up-modal__column">
                        <?php Template::renderIcon('user-alt', 'fontawesome-pro-regular'); ?>
                        <p class="h3">
                            <?= _x('Is this your personal site?', 'admin', 'wp-gdpr-compliance') ?>
                        </p>
                        <button data-signup-private class="wpgdprc-button">
                            <?= _x(
                                'Keep using the plugin for free',
                                'admin',
                                'wp-gdpr-compliance'
                            ) ?>
                        </button>
                    </div>
                    <div class="wpgdprc-sign-up-modal__column">
                        <?php Template::renderIcon('store-alt', 'fontawesome-pro-regular'); ?>
                        <p class="h3">
                            <?= _x('Is this your business site?', 'admin', 'wp-gdpr-compliance') ?>
                        </p>
                        <button data-signup-business class="wpgdprc-button">
                            <?= _x(
                                'Register account',
                                'admin',
                                'wp-gdpr-compliance'
                            ) ?>
                        </button>
                    </div>
                </div>
            </div>

            <div class="wpgdprc-sign-up-modal__step wpgdprc-sign-up-modal__sign-up" style="display: none">
                <iframe id="signupCookieInformation"
                        title="<?= _x('Signup for Cookie Information', 'admin', 'wp-gdpr-compliance') ?>"
                        style="overflow:hidden;height:100%;width:100%" height="100%" width="100%"
                        src="https://cookieinformation.com/only-form/" loading="lazy"
                ></iframe>
            </div>
        </div>
    </div>
</div>
