<?php

namespace WPGDPRC\Utils;

use WPGDPRC\Objects\DataProcessor;
use WPGDPRC\WordPress\Settings;

class Banner {
	/**
	 * @param bool|null $active
	 * @return string
	 */
	public static function statusText( $active = NULL ): string {
		if( is_null($active) ) $active = self::isActive();
		$status = self::activeText($active);
		return sprintf(_x('Consent pop-up is %1s', 'admin', 'wp-gdpr-compliance'), '<span>' . $status . '</span>');
	}

	/**
	 * @param bool|null $active
	 * @return string
	 */
	public static function activeText( $active = NULL ): string {
		if( is_null($active) ) $active = self::isActive();
		return $active ? _x('active', 'admin', 'wp-gdpr-compliance') : _x('not active', 'admin', 'wp-gdpr-compliance');
	}

	/**
	 * @param bool|null $premium
	 * @return string
	 */
	public static function modeText( $premium = NULL ): string {
		if( is_null($premium) ) $premium = Settings::isPremium();
		return $premium ? _x('business', 'admin', 'wp-gdpr-compliance') : _x('free', 'admin', 'wp-gdpr-compliance');
	}

	/**
	 * @param bool|null $premium
	 * @return string
	 */
	public static function enabledText( $premium = NULL ): string {
		if( is_null($premium) ) $premium = Settings::isPremium();
		$mode = self::modeText($premium);
		return sprintf(_x('Currently in %1s mode', 'admin', 'wp-gdpr-compliance'), '<span>' . $mode . '</span>');
	}

	/**
	 * @param bool|null $active
	 * @return string
	 */
	public static function getStatusBanner(bool $active = NULL ): string {
		if( is_null($active) ) $active = DataProcessor::isActive();
		return self::getBanner($active, static::statusText($active));
	}

	/**
	 * @param bool|null $premium
	 *
	 * @return string
	 */
	public static function getPremiumBanner(bool $premium = null) {
		if( is_null($premium) ) $premium = Settings::isPremium();
		return self::getBanner($premium, static::enabledText($premium));
	}

	/**
	 * @param bool $active
	 * @param string $text
	 *
	 * @return string
	 */
	public static function getBanner(bool $active, string $text): string {
		$args = [
			'status' => $active ? 'success' : 'warning',
			'class'  => 'wpgdprc-label--large',
			'text'   => $text,
		];
		return Template::get('Admin/banner', $args);
	}

	/**
	 * @param null $active
	 * @param null $premium
	 *
	 * @return string
	 */
	public static function getStatusAndPremiumBanner($active = null, $premium = null): string {

		if (is_null($active) && is_null($premium)) {
			$premium = Settings::isPremium();
			$active = DataProcessor::isActive();

			if ($premium) {
				$active = $premium;
			}
		}

		return implode('', [
			self::getStatusBanner($active),
			self::getPremiumBanner($premium)
		]);
	}
}
