<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_apps extends Widget_Base {

    public function get_name() {
        return 'apps_short_base';
    }

    public function get_title() {
        return __('Apps - Simple','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'basic', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );

        $this->add_control(
                'bg_img', array(
            'label' => __('Background Image','adforest-elementor'),
            'type' => Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
            "description" => __("1280x480", 'adforest-elementor'),
                )
        );

        $this->add_control(
                'section_title', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'description' => __('For color {color}warp text within this tag{/color}','adforest-elementor'),
            'title' => __('Section Title','adforest-elementor'),
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'andriod', [
            'label' => esc_html__('Andriod','adforest-elementor'),
                ]
        );


        $this->add_control(
                'a_tag_line', [
            'label' => __('Tag Line','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Tag Line','adforest-elementor'),
                ]
        );
        $this->add_control(
                'a_title', [
            'label' => __('Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Title','adforest-elementor'),
                ]
        );
        $this->add_control(
                'a_link', [
            'label' => __('Download Link','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Download Link','adforest-elementor'),
                ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
                'ios', [
            'label' => esc_html__('IOS','adforest-elementor'),
                ]
        );


        $this->add_control(
                'i_tag_line', [
            'label' => __('Tag Line','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Tag Line','adforest-elementor'),
                ]
        );
        $this->add_control(
                'i_title', [
            'label' => __('Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Title','adforest-elementor'),
                ]
        );
        $this->add_control(
                'i_link', [
            'label' => __('Download Link','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Download Link','adforest-elementor'),
                ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
                'windows', [
            'label' => esc_html__('Windows','adforest-elementor'),
                ]
        );


        $this->add_control(
                'w_tag_line', [
            'label' => __('Tag Line','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Tag Line','adforest-elementor'),
                ]
        );
        $this->add_control(
                'w_title', [
            'label' => __('Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Title','adforest-elementor'),
                ]
        );
        $this->add_control(
                'w_link', [
            'label' => __('Download Link','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Download Link','adforest-elementor'),
                ]
        );


        $this->end_controls_section();
    }

    protected function render() {
        $app_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        $adforest_render_params['adforest_elementor'] = TRUE;

        $adforest_render_params['bg_img'] = isset($app_settings_fields['bg_img']['id']) ? $app_settings_fields['bg_img']['id'] : '';
        $adforest_render_params['section_title'] = isset($app_settings_fields['section_title']) ? $app_settings_fields['section_title']:'';

        $adforest_render_params['a_tag_line'] = isset($app_settings_fields['a_tag_line']) ? $app_settings_fields['a_tag_line']:'';
        $adforest_render_params['a_title'] = isset($app_settings_fields['a_title']) ? $app_settings_fields['a_title']:'';
        $adforest_render_params['a_link'] = isset($app_settings_fields['a_link']) ? $app_settings_fields['a_link']:'';

        $adforest_render_params['i_tag_line'] = isset( $app_settings_fields['i_tag_line']) ? $app_settings_fields['i_tag_line']:'';
        $adforest_render_params['i_title'] = isset($app_settings_fields['i_title']) ? $app_settings_fields['i_title']:'';
        $adforest_render_params['i_link'] = isset($app_settings_fields['i_link']) ? $app_settings_fields['i_link']:'';

        $adforest_render_params['w_tag_line'] = isset($app_settings_fields['w_tag_line']) ? $app_settings_fields['w_tag_line']:'';
        $adforest_render_params['w_title'] = isset($app_settings_fields['w_title']) ? $app_settings_fields['w_title']:'';
        $adforest_render_params['w_link'] = isset($app_settings_fields['w_link']) ? $app_settings_fields['w_link']:'';

        echo apps_short_base_func($adforest_render_params);
    }

}
