<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_apps_modern extends Widget_Base
{

    public function get_name()
    {
        return 'app_modern_short_base';
    }

    public function get_title()
    {
        return __('Apps - Modern', 'adforest-elementor');
    }

    public function get_icon()
    {
        return 'fa fa-audio-description';
    }

    public function get_categories()
    {
        return ['adforest_elementor'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'basic', [
                'label' => esc_html__('Basic', 'adforest-elementor'),
            ]
        );

        $this->add_control(
            'modern_bg_img', array(
                'label' => __('Main Image', 'adforest-elementor'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                "description" => __("330x266", 'adforest-elementor'),
            )
        );

        $this->add_control(
            'modern_tag_line', [
                'label' => __('Section Tagline', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
            ]
        );

        $this->add_control(
            'modern_section_title', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Section Title', 'adforest-elementor'),
            ]
        );
        $this->add_control(
            'modern_section_desc', [
                'label' => __('Section Description', 'adforest-elementor'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '',
                'title' => __('Section Description', 'adforest-elementor'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'andriod', [
                'label' => esc_html__('Andriod', 'adforest-elementor'),
            ]
        );

        $this->add_control(
            'modern_android_img', array(
                'label' => __('Android Icon Image', 'adforest-elementor'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                "description" => __("167x49", 'adforest-elementor'),
            )
        );

        $this->add_control(
            'modern_a_link', [
                'label' => __('Download Link', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Download Link', 'adforest-elementor'),
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'ios', [
                'label' => esc_html__('IOS', 'adforest-elementor'),
            ]
        );


        $this->add_control(
            'modern_ios_img', array(
                'label' => __('IOS Icon Image', 'adforest-elementor'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                "description" => __("167x49", 'adforest-elementor'),
            )
        );

        $this->add_control(
            'modern_i_link', [
                'label' => __('Download Link', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Download Link', 'adforest-elementor'),
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        $app_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        $adforest_render_params['adforest_elementor'] = TRUE;

        $adforest_render_params['bg_img_mod'] = isset($app_settings_fields['modern_bg_img']['id']) ? $app_settings_fields['modern_bg_img']['id'] : '';
        $adforest_render_params['tag_line_mod'] = isset($app_settings_fields['modern_tag_line']) ? $app_settings_fields['modern_tag_line'] : '';
        $adforest_render_params['section_title_mod'] = isset($app_settings_fields['modern_section_title']) ? $app_settings_fields['modern_section_title'] : '';
        $adforest_render_params['section_description_mod'] = isset($app_settings_fields['modern_section_desc']) ? $app_settings_fields['modern_section_desc'] : '';

        $adforest_render_params['android_img_mod'] = isset($app_settings_fields['modern_android_img']['id']) ? $app_settings_fields['modern_android_img']['id'] : '';
        $adforest_render_params['a_link_mod'] = isset($app_settings_fields['modern_a_link']) ? $app_settings_fields['modern_a_link'] : '';

        $adforest_render_params['ios_img_mod'] = isset($app_settings_fields['modern_ios_img']['id']) ? $app_settings_fields['modern_ios_img']['id'] : '';
        $adforest_render_params['i_link_mod'] = isset($app_settings_fields['modern_i_link']) ? $app_settings_fields['modern_i_link'] : '';

        if (in_array('dc-woocommerce-multi-vendor/dc_product_vendor.php', apply_filters('active_plugins', get_option('active_plugins')))) {
            echo apps_modern_short_base_func($adforest_render_params);
        }
    }

}
