<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_cats_tab extends Widget_Base {

    public function get_name() {
        return 'cats_tab_short_base';
    }

    public function get_title() {
        return __('Categories - Tabs','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'basic_settings', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );

        $this->add_control(
                'cat_link_page', array(
            'label' => __('Category link Page','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'default' => 5,
            'options' => [
                'search' => __('Search Page','adforest-elementor'),
                'category' => __('Category Page','adforest-elementor'),
            ]
                )
        );

        $this->add_control(
                'section_bg', array(
            'label' => __('Background','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('White','adforest-elementor'),
                'gray' => __('Gray','adforest-elementor'),
                'img' => __('Image','adforest-elementor'),
            ),
                )
        );

        $this->end_controls_section();


        $this->start_controls_section(
                'ads_settings', [
            'label' => esc_html__('Ads Settings','adforest-elementor'),
                ]
        );

        $this->add_control(
                'ad_type', array(
            'label' => __('Ads Type','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('Select Ads Type','adforest-elementor'),
                'feature' => __('Featured Ads','adforest-elementor'),
                'regular' => __('Simple Ads','adforest-elementor'),
                'both' => __('Both','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'ad_order', array(
            'label' => __('Order By','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('Select Ads order','adforest-elementor'),
                'asc' => __('Oldest','adforest-elementor'),
                'desc' => __('Latest','adforest-elementor'),
                'rand' => __('Random','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'layout_type', array(
            'label' => __('Layout Type','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => apply_filters('adforest_elementor_ads_styles', array()),
                )
        );

        $this->add_control(
                'no_of_ads', array(
            'label' => __('Number fo Ads','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => 10,
            'min' => 1,
            'max' => 500,
                )
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'ad_categories', [
            'label' => esc_html__('Categories','adforest-elementor'),
                ]
        );
        $this->add_control(
                'cats_tabs', array(
            'label' => __('Select Category','adforest-elementor'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'default' => '',
            'options' => apply_filters('adforest_elementor_ads_categories', array(), 'ad_cats')
                )
        );

        $this->end_controls_section();
    }

    protected function render() {
        $ads_settings_tabs = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['cat_link_page'] = isset($ads_settings_tabs['cat_link_page']) ? $ads_settings_tabs['cat_link_page']:'';
        $adforest_render_params['section_bg'] = isset($ads_settings_tabs['section_bg']) ? $ads_settings_tabs['section_bg']:'';
        // ads settings
        $adforest_render_params['ad_type'] = isset($ads_settings_tabs['ad_type']) ? $ads_settings_tabs['ad_type']:'';
        $adforest_render_params['ad_order'] = isset($ads_settings_tabs['ad_order']) ? $ads_settings_tabs['ad_order']:'';
        $adforest_render_params['layout_type'] = isset($ads_settings_tabs['layout_type']) ? $ads_settings_tabs['layout_type']:'';
        $adforest_render_params['no_of_ads'] = isset($ads_settings_tabs['no_of_ads']) ? $ads_settings_tabs['no_of_ads']:'';
        //cats
        $adforest_render_params['cats'] = isset($ads_settings_tabs['cats_tabs']) ? $ads_settings_tabs['cats_tabs']:'';
        echo cats_tab_short_base_func($adforest_render_params);
    }

}
