<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_contact_us extends Widget_Base {

    public function get_name() {
        return 'contact_usshort_base';
    }

    public function get_title() {
        return __('Contact Us','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'basic_settings', [
            'label' => esc_html__('Basic Settings','adforest-elementor'),
                ]
        );

        $this->add_control(
                's_title_1', [
            'label' => __('Contact Form Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Contact Form Title','adforest-elementor'),
                ]
        );

        $this->add_control(
                's_title_2', [
            'label' => __('Contact Info Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Contact Info Title','adforest-elementor'),
                ]
        );

        $this->add_control(
                'contact_short_code', [
            'label' => __('Contact form 7 shortcode','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 3,
            'placeholder' => '',
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'address_settings', [
            'label' => esc_html__('Address','adforest-elementor'),
                ]
        );

        $this->add_control(
                'address', [
            'label' => __('Address','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 3,
            'placeholder' => '',
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'phone_settings', [
            'label' => esc_html__('Phone','adforest-elementor'),
                ]
        );


        $this->add_control(
                'phone', [
            'label' => __('Phone','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 3,
            'placeholder' => '',
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'email_settings', [
            'label' => esc_html__('Email','adforest-elementor'),
                ]
        );

        $this->add_control(
                'email', [
            'label' => __('Email','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 3,
            'placeholder' => '',
                ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $contact_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['s_title_1'] = isset($contact_settings_fields['s_title_1']) ? $contact_settings_fields['s_title_1']:'';
        $adforest_render_params['s_title_2'] = isset($contact_settings_fields['s_title_2']) ? $contact_settings_fields['s_title_2']:'';
        $adforest_render_params['contact_short_code'] = isset($contact_settings_fields['contact_short_code']) ? $contact_settings_fields['contact_short_code']:'';
        $adforest_render_params['address'] = isset($contact_settings_fields['address']) ? $contact_settings_fields['address']:'';
        $adforest_render_params['phone'] = isset($contact_settings_fields['phone']) ? $contact_settings_fields['phone']:'';
        $adforest_render_params['email'] = isset($contact_settings_fields['email']) ? $contact_settings_fields['email']:'';
        echo contact_usshort_base_func($adforest_render_params);
    }

}
