<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_fun_facts extends Widget_Base {

    public function get_name() {
        return 'fun_factsshort_base';
    }

    public function get_title() {
        return __('Fun Facts','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'basic_settings', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );

        $this->add_control(
                'bg_img', array(
            'label' => __('Background Image','adforest-elementor'),
            'type' => Controls_Manager::MEDIA,
            "description" => __("1280x800", 'adforest-elementor'),
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                )
        );

        $this->add_control(
                'p_cols', array(
            'label' => __('Header Style','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '4' => __('3 Col','adforest-elementor'),
                '3' => __('4 Col','adforest-elementor'),
            ),
                )
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'fun_settings', [
            'label' => esc_html__('Fun Facts','adforest-elementor'),
                ]
        );
        
        
        $adforest_elementor_repetor = new \Elementor\Repeater();

        $adforest_elementor_repetor->add_control(
                'icon', [
            'label' => __('Icon','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::ICONS,
            
            
                ]
        );

        $adforest_elementor_repetor->add_control(
                'numbers', [
            'label' => __('Numbers','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Numbers','adforest-elementor'),
                ]
        );
        
        $adforest_elementor_repetor->add_control(
                'title', [
            'label' => __('Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Title','adforest-elementor'),
                ]
        );
        
        $adforest_elementor_repetor->add_control(
                'color_title', [
            'label' => __('Color Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Color Title','adforest-elementor'),
                ]
        );
        
        $this->add_control(
                'fun_facts', [
            'label' => __('Fun Fact','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $adforest_elementor_repetor->get_controls(),
            'default' => [],
            'title_field' => '{{{title}}}',
                ]
        );
        
        $this->end_controls_section();
        
    }

    protected function render() {
        
        $fun_facts_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        $adforest_render_params['adforest_elementor'] = TRUE;
        
        $adforest_render_params['bg_img'] = isset($fun_facts_settings_fields['bg_img']['id']) ? $fun_facts_settings_fields['bg_img']['id'] : '';
        $adforest_render_params['header_style'] = isset($fun_facts_settings_fields['header_style']) ? $fun_facts_settings_fields['header_style']:'';
        
    $adforest_render_params['p_cols'] = isset($fun_facts_settings_fields['p_cols']) ? $fun_facts_settings_fields['p_cols']:'';
        $adforest_render_params['fun_facts'] = isset($fun_facts_settings_fields['fun_facts']) ? $fun_facts_settings_fields['fun_facts']:'';
        
        echo fun_factsshort_base_func($adforest_render_params);
        
    }

}
