<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_select_product extends Widget_Base {

    public function get_name() {
        return 'select_product_short_base';
    }

    public function get_title() {
        return __('Select Product','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'basci_seetting', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );

        $this->add_control(
                'bg_img', array(
            'label' => __('Background Image','adforest-elementor'),
            'type' => Controls_Manager::MEDIA,
            "description" => __("1280x480", 'adforest-elementor'),
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                )
        );



        $this->add_control(
                'section_tag_line', [
            'label' => __('Section Tagline','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Section Tagline','adforest-elementor'),
                ]
        );

        $this->add_control(
                'section_title', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Section Title','adforest-elementor'),
                ]
        );


        $this->add_control(
                'link_title', [
            'label' => __('Button Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Button Title','adforest-elementor'),
                ]
        );

        $this->add_control(
                'link', [
            'label' => __('Button Link','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => '',
            'show_external' => true,
            'default' => [
                'url' => '',
                'is_external' => true,
                'nofollow' => true,
            ],
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'main_all_products', [
            'label' => esc_html__('Products','adforest-elementor'),
                ]
        );

        $this->add_control(
                'one_product', array(
            'label' => __('Select Product','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            //'multiple' => true,
            'default' => 'all',
            'placeholder' => 'Select Options',
            'options' => apply_filters('adforest_elementor_get_packages', array()),
                )
        );

        $this->end_controls_section();


        $this->start_controls_section(
                'key_points_settings', [
            'label' => esc_html__('Key Points','adforest-elementor'),
                ]
        );



        $adforest_elementor_repetor = new \Elementor\Repeater();

        $adforest_elementor_repetor->add_control(
                'title', [
            'label' => __('Point','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
                ]
        );

        $this->add_control(
                'points', [
            'label' => __('Add Point','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $adforest_elementor_repetor->get_controls(),
            'default' => [],
            'title_field' => '{{{title}}}',
                ]
        );


        $this->end_controls_section();
    }

    protected function render() {


        $prod_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['bg_img'] = isset($prod_settings_fields['bg_img']['id']) ? $prod_settings_fields['bg_img']['id'] : '';
        $adforest_render_params['section_tag_line'] = isset($prod_settings_fields['section_tag_line']) ? $prod_settings_fields['section_tag_line']:'';
        $adforest_render_params['section_title'] = isset($prod_settings_fields['section_title']) ? $prod_settings_fields['section_title']:'';
        $adforest_render_params['link_title'] = isset($prod_settings_fields['link_title']) ? $prod_settings_fields['link_title']:'';
        $adforest_render_params['link'] = isset($prod_settings_fields['link']) ? $prod_settings_fields['link']:'';
        $adforest_render_params['one_product'] = isset($prod_settings_fields['one_product']) ? $prod_settings_fields['one_product']:'';
        $adforest_render_params['points'] = isset($prod_settings_fields['points']) ? $prod_settings_fields['points']:'';

        echo select_product_short_base_func($adforest_render_params);
    }

}
