<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_shop_layout5 extends Widget_Base
{

    public function get_name()
    {
        return 'shop_layout_short5_base';
    }

    public function get_title()
    {
        return __('Shop Modern - 5', 'adforest-elementor');
    }

    public function get_icon()
    {
        return 'fa fa-audio-description';
    }

    public function get_categories()
    {
        return ['adforest_elementor'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'basic', [
                'label' => esc_html__('Basic', 'adforest-elementor'),
            ]
        );

        $this->add_control(
            'header_style', array(
                'label' => __('Header Style', 'adforest-elementor'),
                'type' => Controls_Manager::SELECT,

                'options' => array(
                    '' => __('No Header', 'adforest-elementor'),
                    'classic' => __('Classic', 'adforest-elementor'),
                    'regular' => __('Regular', 'adforest-elementor'),
                    'fancy' => __('Fancy', 'adforest-elementor'),
                    'modern' => __('Modern', 'adforest-elementor'),
                ),
            )
        );

        $this->add_control(
            'section_title', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'description' => __('For color {color}warp text within this tag{/color}', 'adforest-elementor'),
                'title' => __('Section Title', 'adforest-elementor'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'classic',
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'section_title_regular', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Section Title', 'adforest-elementor'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'regular',
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'section_title_fancy', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Section Title', 'adforest-elementor'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'fancy',
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'section_title_modern', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Section Title', 'adforest-elementor'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'modern',
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'section_description', [
                'label' => __('Section Description', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'title' => '',
                'rows' => 3,
                'placeholder' => '',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'classic',
                                'modern',
                                'fancy'
                            ],
                        ],
                    ],
                ],

            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'product_settings', [
                'label' => esc_html__('Products Setting', 'adforest-elementor'),
            ]
        );
        $this->add_control(
            'max_limit',
            [
                'label' => __('Select Number of Product', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 1000,
                'step' => 1,
                'default' => 4,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'category_settings', [
                'label' => esc_html__('Categories', 'adforest-elementor'),
            ]
        );
        $this->add_control(
            'woo_products', array(
                'label' => __('Select Category', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'default' => 'all',
                'placeholder' => 'Select Options',
                'options' => apply_filters('adforest_elementor_get_product_categories', 'product_cat'),
            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {

        $shop_settings_fields = $this->get_settings_for_display();

        $adforest_render_params = array();
        $adforest_render_params['adforest_elementor'] = TRUE;
        //$adforest_render_params['section_bg'] = isset($shop_settings_fields['section_bg']) ? $shop_settings_fields['section_bg'] : '';
        //$adforest_render_params['bg_img'] = isset($shop_settings_fields['bg_img']['id']) ? $shop_settings_fields['bg_img']['id'] : '';
        $adforest_render_params['header_style'] = isset($shop_settings_fields['header_style']) ? $shop_settings_fields['header_style'] : '';
        $adforest_render_params['section_title'] = isset($shop_settings_fields['section_title']) ? $shop_settings_fields['section_title'] : '';
        $adforest_render_params['section_title_regular'] = isset($shop_settings_fields['section_title_regular']) ? $shop_settings_fields['section_title_regular'] : '';
        $adforest_render_params['section_title_fancy'] = isset($shop_settings_fields['section_title_fancy']) ? $shop_settings_fields['section_title_fancy'] : '';
        $adforest_render_params['section_title_modern'] = isset($shop_settings_fields['section_title_modern']) ? $shop_settings_fields['section_title_modern'] : '';
        $adforest_render_params['section_description'] = isset($shop_settings_fields['section_description']) ? $shop_settings_fields['section_description'] : '';
        $adforest_render_params['max_limit'] = isset($shop_settings_fields['max_limit']) ? $shop_settings_fields['max_limit'] : '';
        $adforest_render_params['woo_products'] = isset($shop_settings_fields['woo_products']) ? $shop_settings_fields['woo_products'] : array();

        echo shop_layout5_short_base_func($adforest_render_params);
    }
}