<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_sign_up extends Widget_Base {

    public function get_name() {
        return 'register_short_base';
    }

    public function get_title() {
        return __('Sign Up','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'general_sett', [
            'label' => esc_html__('General','adforest-elementor'),
                ]
        );

        $this->add_control(
                'sb_bg_color', array(
            'label' => __('Background','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('White','adforest-elementor'),
                'gray' => __('Gray','adforest-elementor'),
                'img' => __('Image','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'bg_img', array(
            'label' => __('Background Image','adforest-elementor'),
            'type' => Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'sb_bg_color',
                        'operator' => 'in',
                        'value' => [
                            'img',
                        ],
                    ],
                ],
            ],
                )
        );

        $this->add_control(
                'section_title', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'description' => __('For color {color}warp text within this tag{/color}','adforest-elementor'),
            'title' => __('Section Title','adforest-elementor'),
                ]
        );

        $this->add_control(
                'terms_title', [
            'label' => __('Terms & Condition Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Terms & Condition Title','adforest-elementor'),
                ]
        );

        $this->add_control(
                'terms_link', [
            'label' => __('Terms & Conditions','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => __('https://your-link.com','adforest-elementor'),
            'show_external' => true,
            'default' => [
                'url' => '',
                'is_external' => true,
                'nofollow' => true,
            ],
                ]
        );

        $this->add_control(
                'is_captcha', array(
            'label' => __('Capcha Code','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            "description" => __("Captcha is for stop spamming", "adforest-elementor"),
            'options' => array(
                '' => __('Please select','adforest-elementor'),
                'with' => __('With Capcha','adforest-elementor'),
                'without' => __('Without Capcha','adforest-elementor'),
            ),
                )
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'features_sett', [
            'label' => esc_html__('Features','adforest-elementor'),
                ]
        );

        $adforest_elementor_repetor = new \Elementor\Repeater();

        $adforest_elementor_repetor->add_control(
                'image', array(
            'label' => __('Image 80x80','adforest-elementor'),
            'type' => Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ]
                )
        );

        $adforest_elementor_repetor->add_control(
                'title', [
            'label' => __('Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
                ]
        );

        $adforest_elementor_repetor->add_control(
                'link', [
            'label' => __('Page Link','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => __('https://your-link.com','adforest-elementor'),
            'show_external' => true,
            'default' => [
                'url' => '',
                'is_external' => true,
                'nofollow' => true,
            ],
                ]
        );

        $adforest_elementor_repetor->add_control(
                'description', [
            'label' => __('Short Description','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 3,
            'placeholder' => '',
                ]
        );

        $this->add_control(
                'features', [
            'label' => __('Add Feature','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $adforest_elementor_repetor->get_controls(),
            'default' => [],
            'title_field' => '{{{title}}}',
                ]
        );

        $this->end_controls_section();
    }

    protected function render() {

        $signup_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['sb_bg_color'] = isset($signup_settings_fields['sb_bg_color']) ? $signup_settings_fields['sb_bg_color']:'';
        $adforest_render_params['bg_img'] = isset($signup_settings_fields['bg_img']['id']) ? $signup_settings_fields['bg_img']['id'] : '';
        $adforest_render_params['section_title'] = isset($signup_settings_fields['section_title']) ? $signup_settings_fields['section_title']:'';
        
        $adforest_render_params['terms_title'] = isset($signup_settings_fields['terms_title']) ? $signup_settings_fields['terms_title']:'';
        $adforest_render_params['terms_link'] = isset($signup_settings_fields['terms_link']) ? $signup_settings_fields['terms_link']:'';
        
        $adforest_render_params['features'] = isset($signup_settings_fields['features']) ? $signup_settings_fields['features']:'';
        $adforest_render_params['is_captcha'] = isset($signup_settings_fields['is_captcha']) ? $signup_settings_fields['is_captcha']:'without';
        echo register_short_base_func($adforest_render_params);
        
    }

}
