<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_Vendor_Banners extends Widget_Base
{

    public function get_name()
    {
        return 'vendor_banners_short_base';
    }

    public function get_title()
    {
        return __('Adforest - Vendor Banners', 'adforest-elementor');
    }

    public function get_icon()
    {
        return 'fa fa-audio-description';
    }

    public function get_categories()
    {
        return ['adforest_elementor'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'basic', [
                'label' => esc_html__('Basic', 'adforest-elementor'),
            ]
        );

        $this->add_control(
            'header_style', array(
                'label' => __('Header Style', 'adforest-elementor'),
                'type' => Controls_Manager::SELECT,

                'options' => array(
                    '' => __('No Header', 'adforest-elementor'),
                    'classic' => __('Classic', 'adforest-elementor'),
                    'regular' => __('Regular', 'adforest-elementor'),
                ),
            )
        );

        $this->add_control(
            'section_title', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'description' => __('For color {color}warp text within this tag{/color}', 'adforest-elementor'),
                'title' => __('Section Title', 'adforest-elementor'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'classic',
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'section_title_regular', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Section Title', 'adforest-elementor'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'regular',
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'section_description', [
                'label' => __('Section Description', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'title' => '',
                'rows' => 3,
                'placeholder' => '',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'classic',
                            ],
                        ],
                    ],
                ],

            ]
        );
        $this->end_controls_section();
        /*
         * left and right
         */
        $this->start_controls_section(
            'vendor_left_right_banners_sec', [
                'label' => esc_html__('Left & Right', 'adforest-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'vendor_banners_lft_rght_img', array(
                'label' => __('Banner Image', 'adforest-elementor'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                "description" => __("312x422", 'adforest-elementor'),
            )
        );
        $repeater->add_control(
            'vendor_banners_lft_rght_link', [
                'label' => __('Banner Image Link', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '#',
            ]
        );
        $this->add_control(
            'vendor_left_right_banners',
            [
                'label' => __('Banner Left and Right Image', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'vendor_banners_lft_rght_img' => '',
                        'vendor_banners_lft_rght_link' => '',
                    ],
                ],
            ]
        );
        $this->end_controls_section();
        /*
         * middle
         */
        $this->start_controls_section(
            'vendor_banners_middle_top_image_sec', [
                'label' => esc_html__('Middle', 'adforest-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'vendor_banners_middle_top_image', array(
                'label' => __('Banner Image', 'adforest-elementor'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                "description" => __("312x422", 'adforest-elementor'),
            )
        );
        $this->add_control(
            'vendor_banners_middle_top_link', [
                'label' => __('Banner Image Link', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '#',
            ]
        );
        $this->end_controls_section();
        /*
         * middle bottom
         */
        $this->start_controls_section(
            'vendor_midle_bottom_banners_sec', [
                'label' => esc_html__('Middle Bottom', 'adforest-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'vendor_banners_bottom_image', array(
                'label' => __('Banner Image', 'adforest-elementor'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                "description" => __("312x422", 'adforest-elementor'),
            )
        );
        $repeater->add_control(
            'vendor_banners_bottom_link', [
                'label' => __('Banner Image Link', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '#',
            ]
        );
        $this->add_control(
            'vendor_midle_bottom_banners',
            [
                'label' => __('Banner Left and Right Image', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'vendor_banners_bottom_image' => '',
                        'vendor_banners_bottom_link' => '',
                    ],
                ],
            ]
        );
        $this->end_controls_section();

        //===============
    }

    protected function render()
    {
        $app_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();

        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['header_style'] = isset($app_settings_fields['header_style']) ? $app_settings_fields['header_style'] : '';
        $adforest_render_params['section_title'] = isset($app_settings_fields['section_title']) ? $app_settings_fields['section_title'] : '';
        $adforest_render_params['section_title_regular'] = isset($app_settings_fields['section_title_regular']) ? $app_settings_fields['section_title_regular'] : '';
        $adforest_render_params['section_description'] = isset($app_settings_fields['section_description']) ? $app_settings_fields['section_description'] : '';

        $adforest_render_params['vendor_left_right_banners'] = isset($app_settings_fields['vendor_left_right_banners']) ? $app_settings_fields['vendor_left_right_banners'] : array();
        $adforest_render_params['vendor_banners_middle_top_image'] = isset($app_settings_fields['vendor_banners_middle_top_image']['id']) ? $app_settings_fields['vendor_banners_middle_top_image']['id'] : '';
        $adforest_render_params['vendor_banners_middle_top_link'] = isset($app_settings_fields['vendor_banners_middle_top_link']) ? $app_settings_fields['vendor_banners_middle_top_link'] : '';

        $adforest_render_params['vendor_midle_bottom_banners'] = isset($app_settings_fields['vendor_midle_bottom_banners']) ? $app_settings_fields['vendor_midle_bottom_banners'] : array();

        echo adforest_vendor_banners_func($adforest_render_params);

    }

}
