<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_Vendor_Grid extends Widget_Base
{

    public function get_name()
    {
        return 'shop_vendor_grid_base';
    }

    public function get_title()
    {
        return __('Adforest - Vendor Grid', 'adforest-elementor');
    }

    public function get_icon()
    {
        return 'fa fa-audio-description';
    }

    public function get_categories()
    {
        return ['adforest_elementor'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'basic', [
                'label' => esc_html__('Basic', 'adforest-elementor'),
            ]
        );

        $this->add_control(
            'header_style', array(
                'label' => __('Header Style', 'adforest-elementor'),
                'type' => Controls_Manager::SELECT,

                'options' => array(
                    '' => __('No Header', 'adforest-elementor'),
                    'classic' => __('Classic', 'adforest-elementor'),
                    'regular' => __('Regular', 'adforest-elementor'),
                    'fancy' => __('Fancy', 'adforest-elementor'),
                    'modern' => __('Modern', 'adforest-elementor'),
                ),
            )
        );

        $this->add_control(
            'section_title', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'description' => __('For color {color}warp text within this tag{/color}', 'adforest-elementor'),
                'title' => __('Section Title', 'adforest-elementor'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'classic',
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'section_title_regular', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Section Title', 'adforest-elementor'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'regular',
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'section_title_fancy', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Section Title', 'adforest-elementor'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'fancy',
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'section_title_modern', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Section Title', 'adforest-elementor'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'modern',
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'section_description', [
                'label' => __('Section Description', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'title' => '',
                'rows' => 3,
                'placeholder' => '',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'classic',
                                'modern',
                                'fancy'
                            ],
                        ],
                    ],
                ],

            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'vendor_settings', [
                'label' => esc_html__('Vendor Setting', 'adforest-elementor'),
            ]
        );
        $this->add_control(
            'no_of_vendors',
            [
                'label' => __('Number of Vendors', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 1000,
                'step' => 1,
                'default' => 4,
            ]
        );
        $this->add_control(
            'link_title', [
                'label' => __('Button Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Link Title', 'adforest-elementor'),
            ]
        );
        $this->add_control(
            'main_link', [
                'label' => __('Button Link', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => '',
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {

        $shop_settings_fields = $this->get_settings_for_display();

        $adforest_render_params = array();
        $adforest_render_params['adforest_elementor'] = TRUE;

        $adforest_render_params['bg_img'] = isset($shop_settings_fields['bg_img']['id']) ? $shop_settings_fields['bg_img']['id'] : '';
        $adforest_render_params['header_style'] = isset($shop_settings_fields['header_style']) ? $shop_settings_fields['header_style'] : '';
        $adforest_render_params['section_title'] = isset($shop_settings_fields['section_title']) ? $shop_settings_fields['section_title'] : '';
        $adforest_render_params['section_title_regular'] = isset($shop_settings_fields['section_title_regular']) ? $shop_settings_fields['section_title_regular'] : '';
        $adforest_render_params['section_title_fancy'] = isset($shop_settings_fields['section_title_fancy']) ? $shop_settings_fields['section_title_fancy'] : '';
        $adforest_render_params['section_title_modern'] = isset($shop_settings_fields['section_title_modern']) ? $shop_settings_fields['section_title_modern'] : '';
        $adforest_render_params['section_description'] = isset($shop_settings_fields['section_description']) ? $shop_settings_fields['section_description'] : '';

        $adforest_render_params['no_of_vendors'] = isset($shop_settings_fields['no_of_vendors']) ? $shop_settings_fields['no_of_vendors'] : '';
        $adforest_render_params['link_title'] = isset($shop_settings_fields['link_title']) ? $shop_settings_fields['link_title'] : '';
        $adforest_render_params['main_link'] = isset($shop_settings_fields['main_link']) ? $shop_settings_fields['main_link'] : '';

        echo vendro_grid_base_func($adforest_render_params);
    }
}