<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_Vendor_Hero_Slider extends Widget_Base
{

    public function get_name()
    {
        return 'vendor_hero_short_base';
    }

    public function get_title()
    {
        return __('Adforest - Vendor Hero', 'adforest-elementor');
    }

    public function get_icon()
    {
        return 'fa fa-audio-description';
    }

    public function get_categories()
    {
        return ['adforest_elementor'];
    }

    protected function _register_controls()
    {
        /*
         * Hero slider
         */
        $this->start_controls_section(
            'vendor_slides_sec', [
                'label' => esc_html__('Slider Settings', 'adforest-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'slider_signature_image', array(
                'label' => __('Slider Signature Image', 'adforest-elementor'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                "description" => __("175 X 66", 'adforest-elementor'),
            )
        );
        $repeater->add_control(
            'slider_image', array(
                'label' => __('Slider Image', 'adforest-elementor'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                "description" => __("1650 X 550", 'adforest-elementor'),
            )
        );
        $repeater->add_control(
            'slider_title', [
                'label' => __('Slider Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
            ]
        );
        $repeater->add_control(
            'slider_base_line', [
                'label' => __('Slider Base Line', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
            ]
        );
        $repeater->add_control(
            'slider_video_link', [
                'label' => __('Video Link', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
            ]
        );
        $repeater->add_control(
            'slider_video_text', [
                'label' => __('Video Text', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
            ]
        );
        $repeater->add_control(
            'slider_off_sale_num', [
                'label' => __('Value for Discount', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
            ]
        );
        $repeater->add_control(
            'link_title', [
                'label' => __('Button Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Link Title', 'adforest-elementor'),
            ]
        );
        $repeater->add_control(
            'main_link', [
                'label' => __('Button Link', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => '',
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            'vendor_slides',
            [
                'label' => __('Banner Left and Right Image', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'slider_signature_image' => '',
                        'slider_image' => '',
                        'slider_title' => '',
                        'slider_base_line' => '',
                        'slider_video_link' => '',
                        'slider_video_text' => '',
                        'slider_off_sale_num' => '',
                        'link_title' => '',
                        'main_link' => '',
                    ],
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $app_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();

        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['vendor_slides'] = isset($app_settings_fields['vendor_slides']) ? $app_settings_fields['vendor_slides'] : array();

        echo adforest_hero_vendro_slider_callback($adforest_render_params);
    }

}
