<?php
namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_z_adforest_visited_ads extends Widget_Base {

    public function get_name() {
        return 'adforest_visited_ads';
    }

    public function get_title() {
        return __('Adforest Visited Ads','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

       $this->start_controls_section(
                'basic', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );

        $this->add_control(
                'section_bg', array(
            'label' => __('Background Color','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'description' => __('Select background color.','adforest-elementor'),        
            'options' => array(
                '' => __('White','adforest-elementor'),
                'gray' => __('Gray','adforest-elementor'),
            ),
                )
        );
        
        
        
        
        $this->add_control(
                'header_style', array(
            'label' => __('Header Style','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'description' => __('Chose header style.','adforest-elementor'),        
            'options' => array(
                '' => __('No Header','adforest-elementor'),
                'classic' => __('Classic','adforest-elementor'),
                'regular' => __('Regular','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'section_title', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Section Title','adforest-elementor'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'classic',
                        ],
                    ],
                ],
            ],
             'description' => __('For color {color}warp text within this tag{/color}','adforest-elementor'),        
        
                ]
        );
         $this->add_control(
                'section_description', [
            'label' => __('Section Description','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 3,
            'placeholder' => '',
             'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'classic',
                        ],
                    ],
                ],
            ],
                    
                ]
        );
        $this->add_control(
                'section_title_regular', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Section Title','adforest-elementor'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'regular',
                        ],
                    ],
                ],
            ],
                ]
        );

        
        $this->add_control(
                'ads_columns', array(
            'label' => __('Ads Column','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '4' => __('3 Column','adforest-elementor'),
                '3' => __('4 Column','adforest-elementor'),
                
            ),
                )
        );
        
     
        $this->end_controls_section(); 
        
        
        $this->start_controls_section(
                'adset', [
            'label' => esc_html__('Ads Settings','adforest-elementor'),
                ]
        );
        
        
        $this->add_control(
                'layout_type', array(
            'label' => __('Layout Type','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'grid_1' => __('Grid 1','adforest-elementor'),
                'grid_2' => __('Grid 2','adforest-elementor'),
                'grid_3' => __('Grid 3','adforest-elementor'),
                'grid_4' => __('Grid 4','adforest-elementor'),
                'grid_5' => __('Grid 5','adforest-elementor'),
                'grid_6' => __('Grid 6','adforest-elementor'),
                'grid_7' => __('Grid 7','adforest-elementor'),
                'grid_8' => __('Grid 8','adforest-elementor'),
                'grid_9' => __('Grid 9','adforest-elementor'),
                'grid_10' => __('Grid 10','adforest-elementor'),
            ),
                )
        );
        
        $this->add_control(
	        'no_of_ads',
	         [
		'label' => __('Number fo Ads','adforest-elementor' ),
		'type' => \Elementor\Controls_Manager::NUMBER,
		'min' => 1,
		'max' => 500,
		'step' => 1,
		'default' => 1,
                
			]
		); 
        
        
        
         $this->end_controls_section(); 
        
        
        


    }

    protected function render() {
    $package_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE; 
        
         
        $adforest_render_params['section_bg'] = isset($package_settings_fields['section_bg']) ? $package_settings_fields['section_bg'] : '';
        $adforest_render_params['header_style'] = isset($package_settings_fields['header_style']) ? $package_settings_fields['header_style'] : '';
        $adforest_render_params['section_title'] = isset($package_settings_fields['section_title']) ? $package_settings_fields['section_title'] : '';
        $adforest_render_params['section_description'] = isset($package_settings_fields['section_description']) ? $package_settings_fields['section_description'] : '';
        $adforest_render_params['section_title_regular'] = isset($package_settings_fields['section_title_regular']) ? $package_settings_fields['section_title_regular'] : '';
        $adforest_render_params['ads_columns'] = isset($package_settings_fields['ads_columns']) ? $package_settings_fields['ads_columns'] : '';
        
        $adforest_render_params['layout_type'] = isset($package_settings_fields['layout_type']) ? $package_settings_fields['layout_type'] : '';
        $adforest_render_params['no_of_ads'] = isset($package_settings_fields['no_of_ads']) ? $package_settings_fields['no_of_ads'] : '';
             
         echo adforest_visited_ads_callback($adforest_render_params);
        
    }
}