<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_z_search_hero_classic extends Widget_Base {

    public function get_name() {
        return 'search_hero_classic_short_base';
    }

    public function get_title() {
        return __('Search - Hero Classic','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'search-hero-classic', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );

        $this->add_control(
                'block_text', array(
            'label' => __('Form Heading Text','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
                )
        );


        $this->add_control(
                'bg_img', [
            'label' => __('Background Image','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'description' => '1280X800',
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );


        $this->add_control(
                'side_img', [
            'label' => __('Side Image','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'description' => '1280X800',
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );



        $this->add_control(
                'image_pos', [
            'label' => __('Image Position','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '',
            'options' => [
                '' => __('Select Option','adforest-elementor'),
                'left' => __('Left','adforest-elementor'),
                'right' => __('Right','adforest-elementor'),
            ],
                ]
        );




        $this->end_controls_section();




        $this->start_controls_section(
                'location_type_sec', [
            'label' => esc_html__('Location type','adforest-elementor'),
                ]
        );


        $this->add_control(
                'location_type', [
            'label' => __('Location type','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'placeholder' => 'Select Options',
            'default' => 'g_locations',
            //'multiple'=>true,
            'options' => [
                'g_locations' => __('Google','adforest-elementor'),
                'custom_locations' => __('Custom Location','adforest-elementor'),
            ],
                ]
        );



        $this->add_control(
                'location', [
            'label' => __('Custom Locations','adforest-elementor'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'default' => '',
            'description' =>'',
            'title' => __('Section Title','adforest-elementor'),
            'options' => apply_filters('adforest_elementor_ads_categories', array(), 'ad_country', 'yes'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'location_type',
                        'operator' => 'in',
                        'value' => [
                            'custom_locations',
                        ],
                    ],
                ],
            ],
                ]
        );



        $this->end_controls_section();



        $this->start_controls_section(
                'categories', [
            'label' => esc_html__('Categories','adforest-elementor'),
                ]
        );


        $this->add_control(
                'cat_frontend_switch', [
            'label' => __('Select Category ( All or Selective )','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'placeholder' => 'Select Options',
            'default' => '',
            'description' => __('Categories Load on frontend','adforest-elementor'),
            'multiple' => true,
            'options' => [
                'default' => __('Default','adforest-elementor'),
                'ajax_based' => __('Ajax Based (Load All)','adforest-elementor'),
            ],
                ]
        );

        $this->add_control(
                'cats', [
            'label' => __('Select Category ( All or Selective )','adforest-elementor'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'default' => '',
            'description' => __('Select Category ( All or Selective )','adforest-elementor'),
            'title' => __('Section Title','adforest-elementor'),
            //'options' => apply_filters('cat_frontend_switch', array(), 'ad_cats'),	
            'options' => apply_filters('adforest_elementor_ads_categories', array(), 'ad_cats', 'yes'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'cat_frontend_switch',
                        'operator' => 'in',
                        'value' => [
                            'default',
                        ],
                    ],
                ],
            ],
                ]
        );


        $this->end_controls_section();
    }

    protected function render() {

        $search_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['block_text'] = isset($search_settings_fields['block_text']) ? $search_settings_fields['block_text'] : '';
        $adforest_render_params['bg_img'] = isset($search_settings_fields['bg_img']['id']) ? $search_settings_fields['bg_img']['id'] : '';
        $adforest_render_params['side_img'] = isset($search_settings_fields['side_img']['id']) ? $search_settings_fields['side_img']['id'] : '';
        $adforest_render_params['image_pos'] = isset($search_settings_fields['image_pos']) ? $search_settings_fields['image_pos'] : '';
        $adforest_render_params['locations'] = isset($search_settings_fields['location']) ? $search_settings_fields['location'] : '';
        $adforest_render_params['location_type'] = isset($search_settings_fields['location_type']) ? $search_settings_fields['location_type'] : '';
        $adforest_render_params['cat_frontend_switch'] = isset($search_settings_fields['cat_frontend_switch']) ? $search_settings_fields['cat_frontend_switch'] : '';
        $adforest_render_params['cats'] = isset($search_settings_fields['cats']) ? $search_settings_fields['cats'] : '';

        echo search_hero_classic_short_base_func($adforest_render_params);
    }

}
