<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_z_search_modern2 extends Widget_Base {

    public function get_name() {
        return 'search_modern2';
    }

    public function get_title() {
        return __('Search - Modern 2','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        // basic
        $this->start_controls_section(
                'basic', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );

        $this->add_control(
                'header_style', array(
            'label' => __('Header Style','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('No Header','adforest-elementor'),
                'classic' => __('Classic','adforest-elementor'),
                'regular' => __('Regular','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'section_title', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'description' => __('For color {color}warp text within this tag{/color}','adforest-elementor'),
            'title' => __('Section Title','adforest-elementor'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'classic',
                        ],
                    ],
                ],
            ],
                ]
        );
        $this->add_control(
                'section_title_regular', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Section Title','adforest-elementor'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'regular',
                        ],
                    ],
                ],
            ],
                ]
        );

        $this->add_control(
                'section_description', [
            'label' => __('Section Description','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 3,
            'placeholder' => '',
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'classic',
                        ],
                    ],
                ],
            ],
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'Search Settings', [
            'label' => esc_html__('Search Settings','adforest-elementor'),
                ]
        );

        $this->add_control(
                'location_type', [
            'label' => __('Location type','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'placeholder' => 'Select Options',
            'default' => 'g_locations',
            'options' => [
                'g_locations' => __('Google','adforest-elementor'),
                'custom_locations' => __('Custom Location','adforest-elementor'),
            ],
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'custom_location', [
            'label' => esc_html__('Custom Locations','adforest-elementor'),
                ]
        );


        $this->add_control(
                'locations', [
            'label' => __('Location','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'default' => 'All Countries',
            'multiple' => true,
            'options' => apply_filters('adforest_elementor_ads_categories', array(), 'ad_country', 'yes'),
                ]
        );


        $this->end_controls_section();
    }

    protected function render() {
        $search_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['header_style'] = isset($search_settings_fields['header_style']) ? $search_settings_fields['header_style'] : '';
        $adforest_render_params['section_title'] = isset($search_settings_fields['section_title']) ? $search_settings_fields['section_title'] : '';
        $adforest_render_params['section_title_regular'] = isset($search_settings_fields['section_title_regular']) ? $search_settings_fields['section_title_regular'] : '';
        $adforest_render_params['section_description'] = isset($search_settings_fields['section_description']) ? $search_settings_fields['section_description'] : '';
        //
        $adforest_render_params['location_type'] = isset($search_settings_fields['location_type']) ? $search_settings_fields['location_type'] : '';
        $adforest_render_params['locations'] = isset($search_settings_fields['locations']) ? $search_settings_fields['locations'] : '';

        echo search_modern2_func_callback($adforest_render_params);
    }

}
