<?php
/*
 * Adforest Elementor Function Class
 */
Class Adforest_Elementor_Functions {

    public function __construct() {
        add_filter('adforest_elementor_url_field', array($this, 'adforest_elementor_url_field_callback'), 10, 2);
        add_filter('adforest_elementor_ads_styles', array($this, 'adforest_elementor_ads_styles_callback'));
        add_filter('adforest_elementor_ads_categories', array($this, 'adforest_elementor_ads_categories_callback'), 10, 3);
        add_filter('adforest_elementor_get_packages', array($this, 'adforest_elementor_get_packages_callback'));
        add_filter('adforest_elementor_get_product_categories', array($this, 'adforest_product_categories_callback'));
    }
    public function adforest_elementor_get_packages_callback($cats_arr = array()) {
        
         global $adforest_theme;
         $products = array();

        if (isset($adforest_theme['shop-turn-on']) && $adforest_theme['shop-turn-on']) {
            $args = array(
                'tax_query' => array(
                    array(
                        'taxonomy' => 'product_type',
                        'field' => 'slug',
                        'terms' => array('adforest_classified_pkgs','subscription','variable-subscription'),
                    ),
                ),
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => -1,
                'order' => 'DESC',
                'orderby' => 'ID',
            );
        } else {
            $args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => -1,
                'order' => 'DESC',
                'orderby' => 'ID',
            );
        }

        $args = apply_filters('adforest_wpml_show_all_posts', $args);
        $packages = new WP_Query($args);
        if ($packages->have_posts()) {
            while ($packages->have_posts()) {
                $packages->the_post();
                $products[get_the_ID()] = get_the_title();
                
            }
        }
        return $products;
    }

    public function adforest_elementor_ads_categories_callback($cats_arr = array(), $taxonomy = 'ad_cats', $all = '') {


        if ($all == 'yes') {
            $cats_arr['all'] = __('All', 'adforest-elementor');
        } else if ($taxonomy == 'ad_country') {
            $cats_arr[''] = __('Select Location', 'adforest-elementor');
        } else if ($taxonomy == 'ad_warranty') {
            $cats_arr[''] = __('Select Warranty', 'adforest-elementor');
        } else if ($taxonomy == 'ad_condition') {
            $cats_arr[''] = __('Select Condition', 'adforest-elementor');
        } else if ($taxonomy == 'ad_type') {
            $cats_arr[''] = __('Select Ad Type', 'adforest-elementor');
        } else if ($taxonomy == 'product_cat') {
            $cats_arr[''] = __('Select Product Type', 'adforest-elementor');
        } else {
            $cats_arr[''] = __('Select ad categories', 'adforest-elementor');
        }

        $args = array('hide_empty' => 0);
        $args = apply_filters('adforest_wpml_show_all_posts', $args); // for all lang texonomies
        $ad_cats = get_terms($taxonomy, $args);

        if (count((array)$ad_cats) > 0) {
            foreach ($ad_cats as $cat) {
                $count = ($cat->count);
                $cats_arr[$cat->term_id] = wp_specialchars_decode($cat->name) . ' ( ' . urldecode_deep($cat->slug) . ' ) ' . ' ( ' . $count . ' ) ';
            }
        }

        return $cats_arr;
    }

    public function adforest_elementor_ads_styles_callback() {

        $grid_array;
        if (Redux::getOption('adforest_theme', 'design_type') == 'modern') {
            $grid_array = array(
                '' => __('Select Layout Type', 'adforest-elementor'),
                'grid_1' => __('Grid 1', 'adforest-elementor'),
                'grid_2' => __('Grid 2', 'adforest-elementor'),
                'grid_3' => __('Grid 3', 'adforest-elementor'),
                'grid_4' => __('Grid 4', 'adforest-elementor'),
                'grid_5' => __('Grid 5', 'adforest-elementor'),
                'grid_6' => __('Grid 6', 'adforest-elementor'),
                'grid_7' => __('Grid 7', 'adforest-elementor'),
                'grid_8' => __('Grid 8', 'adforest-elementor'),
                'grid_9' => __('Grid 9', 'adforest-elementor'),
                'grid_10' => __('Grid 10', 'adforest-elementor'),
                'list' => __('List', 'adforest-elementor'),
            );
        } else {
            $grid_array = array(
                '' => __('Select Layout Type', 'adforest-elementor'),
                'grid_1' => __('Grid 1', 'adforest-elementor'),
                'grid_2' => __('Grid 2', 'adforest-elementor'),
                'grid_3' => __('Grid 3', 'adforest-elementor'),
                'list' => __('List', 'adforest-elementor'),
            );
        }

        return $grid_array;
    }

    public function adforest_elementor_url_field_callback($link_html, $params_data = array()) {
        extract($params_data);
        $buttonHTML = '';
        if (isset($adforest_elementor) && $adforest_elementor) {
            if (isset($btn_key["url"]) && $btn_key["url"] != "") {
                $is_external = isset($btn_key["is_external"]) && $btn_key["is_external"] == 1 ? ' target="__blank" ' : '';
                $nofollow = isset($btn_key["nofollow"]) && $btn_key["nofollow"] == 1 ? ' rel="nofollow" ' : '';
                $custom_attr = isset($btn_key["custom_attributes"]) && $btn_key["custom_attributes"] != '' ? $btn_key["custom_attributes"] : '';
                $class = ( $btn_class != "" ) ? 'class="' . esc_attr($btn_class) . '" ' : '';

                if (isset($onlyAttr) && $onlyAttr) {
                    $btn_html = $class . 'href="' . $btn_key["url"] . '" ' . $is_external . ' ' . $nofollow . ' ' . $custom_attr;
                } else {
                    $btn_html = '<a ' . $class . 'href="' . $btn_key["url"] . '" ' . $is_external . ' ' . $nofollow . ' ' . $custom_attr . '>' . $iconBefore . ' ' . esc_html($titleText) . ' ' . $iconAfter . '</a>';
                }

                $buttonHTML = ( isset($titleText) ) ? $btn_html : "";
            }
        }
        return $buttonHTML;
    }
    
    
   
     public function adforest_product_categories_callback($term_type = 'product_cat')
    {
        global $adforest_theme;
        if (isset($adforest_theme['shop-turn-on']) && $adforest_theme['shop-turn-on']) {
            $terms = get_terms($term_type, array('hide_empty' => false));
            $result = array();
            if (count((array)$terms) > 0 && !empty($terms) && !is_wp_error($terms)) {
                foreach ($terms as $term) {
                    $result[$term->slug] = $term->name;
                }
            }
            return $result;
        }
    }
    
    
    
    

}

new Adforest_Elementor_Functions();




add_action('init', 'adforest_elementor_plugin_initializaion_func');
if (!function_exists('adforest_elementor_plugin_initializaion_func')) {

    function adforest_elementor_plugin_initializaion_func() {

        $code_verification = get_option('_sb_purchase_code_ele_verification');
        if (isset($code_verification) && $code_verification == 'done') {
            
        } else {
            $my_keyname = array("_", "s", "b", "_", "p", "u", "r", "c", "h", "a", "s", "e", "_", "c", "o", "d", "e");
            $kyname = implode($my_keyname);
            $my_keynamelink = array("h", "t", "t", "p", "s", ":", "/", "/", "a", "u", "t", "h", "e", "n", "t", "i", "c", "a", "t", "e", ".", "s", "c", "r", "i", "p", "t", "s", "b", "u", "n", "d", "l", "e", ".", "c", "o", "m", "/", "a", "d", "f", "o", "r", "e", "s", "t", "/", "v", "e", "r", "i", "f", "y", "_", "p", "c", "o", "d", "e", ".", "p", "h", "p");
            $my_keynameUrl = implode($my_keynamelink);
            $sb_theme_pcode = get_option($kyname);
            if( $sb_theme_pcode != "")
            {
                $theme_name = "Adforest Elementor";
                $data = "?purchase_code=" . $sb_theme_pcode . "&id=" . get_option('admin_email') . '&url=' . get_option('siteurl') . '&theme_name=' . $theme_name;
                $url = esc_url($my_keynameUrl) . $data;
                $response = @wp_remote_get($url);
                if (is_array($response) && !is_wp_error($response)) {
                    update_option('_sb_purchase_code_ele_verification', 'done');
                } else {
                    update_option('_sb_purchase_code_ele_verification', '');
                }
            }
        }
    }

}


/*
     * Get Product Categories
     */
   