<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_blog extends Widget_Base {

    public function get_name() {
        return 'blog_short_base';
    }

    public function get_title() {
        return __('Blog Posts','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        // basic

        $this->start_controls_section(
                'basic', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );

        $this->add_control(
                'section_bg', array(
            'label' => __('Background','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('White','adforest-elementor'),
                'gray' => __('Gray','adforest-elementor'),
                'img' => __('Image','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'bg_img', array(
            'label' => __('Background Image','adforest-elementor'),
            'type' => Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'section_bg',
                        'operator' => 'in',
                        'value' => [
                            'img',
                        ],
                    ],
                ],
            ],
                )
        );

        $this->add_control(
                'header_style', array(
            'label' => __('Header Style','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('No Header','adforest-elementor'),
                'classic' => __('Classic','adforest-elementor'),
                'regular' => __('Regular','adforest-elementor'),
                'fancy' => __('Fancy','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'section_title', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'description' => __('For color {color}warp text within this tag{/color}','adforest-elementor'),
            'title' => __('Section Title','adforest-elementor'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'classic',
                        ],
                    ],
                ],
            ],
                ]
        );
        $this->add_control(
                'section_title_regular', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Section Title','adforest-elementor'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'regular',
                        ],
                    ],
                ],
            ],
                ]
        );
        $this->add_control(
                'section_title_fancy', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Section Title','adforest-elementor'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'fancy',
                        ],
                    ],
                ],
            ],
                ]
        );

        $this->add_control(
                'section_description', [
            'label' => __('Section Description','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 3,
            'placeholder' => '',
                ]
        );

        $this->add_control(
                'max_limit', array(
            'label' => __('Number fo Posts','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => __('10','adforest-elementor'),
            'min' => 1,
            'max' => 500,
                )
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'ad_categories', [
            'label' => esc_html__('Categories','adforest-elementor'),
                ]
        );

        $this->add_control(
                'cats', array(
            'label' => __('Select Category','adforest-elementor'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'default' => '',
            'options' => apply_filters('adforest_elementor_ads_categories', array(), 'category','no')
                )
        );
        $this->end_controls_section();
        
        
        
    }

    protected function render() {
        $blog_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE;        
        $adforest_render_params['section_bg'] = isset($blog_settings_fields['section_bg']) ? $blog_settings_fields['section_bg']:'';
        $adforest_render_params['bg_img'] = isset($blog_settings_fields['bg_img']['id']) ? $blog_settings_fields['bg_img']['id'] : '';
        $adforest_render_params['header_style'] = isset($blog_settings_fields['header_style']) ? $blog_settings_fields['header_style']:'';
        $adforest_render_params['section_title'] = isset($blog_settings_fields['section_title']) ? $blog_settings_fields['section_title']:'';
        $adforest_render_params['section_title_regular'] = isset($blog_settings_fields['section_title_regular']) ? $blog_settings_fields['section_title_regular']:'';
        $adforest_render_params['section_title_fancy'] = isset($blog_settings_fields['section_title_fancy']) ? $blog_settings_fields['section_title_fancy']:'';
        $adforest_render_params['section_description'] = isset($blog_settings_fields['section_description']) ? $blog_settings_fields['section_description']:'';
        
        $adforest_render_params['max_limit'] = isset($blog_settings_fields['max_limit']) ? $blog_settings_fields['max_limit']:'';
        $adforest_render_params['cats'] = isset($blog_settings_fields['cats']) ? $blog_settings_fields['cats']:'';
        echo blog_short_base_func($adforest_render_params);

    }

}
