<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_process_cycle extends Widget_Base {

    public function get_name() {
        return 'process_cycle_short_base';
    }

    public function get_title() {
        return __('Process Cycle','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        // basic

        $this->start_controls_section(
                'basic', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );

        $this->add_control(
                'section_bg', array(
            'label' => __('Background','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('White','adforest-elementor'),
                'gray' => __('Gray','adforest-elementor'),
                'img' => __('Image','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'bg_img', array(
            'label' => __('Background Image','adforest-elementor'),
            'type' => Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'section_bg',
                        'operator' => 'in',
                        'value' => [
                            'img',
                        ],
                    ],
                ],
            ],
                )
        );

        $this->add_control(
                'header_style', array(
            'label' => __('Header Style','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('No Header','adforest-elementor'),
                'classic' => __('Classic','adforest-elementor'),
                'regular' => __('Regular','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'section_title', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'description' => __('For color {color}warp text within this tag{/color}','adforest-elementor'),
            'title' => __('Section Title','adforest-elementor'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'classic',
                        ],
                    ],
                ],
            ],
                ]
        );
        $this->add_control(
                'section_title_regular', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Section Title','adforest-elementor'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'regular',
                        ],
                    ],
                ],
            ],
                ]
        );

        $this->add_control(
                'section_description', [
            'label' => __('Section Description','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 3,
            'placeholder' => '',
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'step_1_settings', [
            'label' => esc_html__('Step 1','adforest-elementor'),
                ]
        );
        $this->add_control(
                's1_icon', [
            'label' => __('Icon','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value' => 'fas fa-star',
                'library' => 'solid',
            ],
                ]
        );

        $this->add_control(
                's1_title', [
            'label' => __('Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Title','adforest-elementor'),
                ]
        );

        $this->add_control(
                's1_description', [
            'label' => __('Description','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 5,
            'placeholder' => '',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'step_2_settings', [
            'label' => esc_html__('Step 2','adforest-elementor'),
                ]
        );
        $this->add_control(
                's2_icon', [
            'label' => __('Icon','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value' => 'fas fa-star',
                'library' => 'solid',
            ],
                ]
        );

        $this->add_control(
                's2_title', [
            'label' => __('Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Title','adforest-elementor'),
                ]
        );

        $this->add_control(
                's2_description', [
            'label' => __('Description','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 5,
            'placeholder' => '',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'step_3_settings', [
            'label' => esc_html__('Step 3','adforest-elementor'),
                ]
        );
        $this->add_control(
                's3_icon', [
            'label' => __('Icon','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value' => 'fas fa-star',
                'library' => 'solid',
            ],
                ]
        );

        $this->add_control(
                's3_title', [
            'label' => __('Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Title','adforest-elementor'),
                ]
        );

        $this->add_control(
                's3_description', [
            'label' => __('Description','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 5,
            'placeholder' => '',
                ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        
         $steps_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE;        
        $adforest_render_params['section_bg'] = isset($steps_settings_fields['section_bg']) ? $steps_settings_fields['section_bg']:'';
        $adforest_render_params['bg_img'] = isset($steps_settings_fields['bg_img']['id']) ? $steps_settings_fields['bg_img']['id'] : '';
        $adforest_render_params['header_style'] = isset($steps_settings_fields['header_style']) ? $steps_settings_fields['header_style']:'';
        $adforest_render_params['section_title'] = isset($steps_settings_fields['section_title']) ? $steps_settings_fields['section_title']:'';
        $adforest_render_params['section_title_regular'] = isset($steps_settings_fields['section_title_regular']) ? $steps_settings_fields['section_title_regular']:'';
        $adforest_render_params['section_description'] = isset($steps_settings_fields['section_description']) ? $steps_settings_fields['section_description']:'';
        //step 1
        $adforest_render_params['s1_icon'] = isset($steps_settings_fields['s1_icon']) ? $steps_settings_fields['s1_icon']:'';
        $adforest_render_params['s1_title'] = isset($steps_settings_fields['s1_title']) ? $steps_settings_fields['s1_title']:'';
        $adforest_render_params['s1_description'] = isset($steps_settings_fields['s1_description']) ? $steps_settings_fields['s1_description']:'';
        //step 2
        $adforest_render_params['s2_icon'] = isset($steps_settings_fields['s2_icon']) ? $steps_settings_fields['s2_icon']:'';
        $adforest_render_params['s2_title'] = isset($steps_settings_fields['s2_title']) ? $steps_settings_fields['s2_title']:'';
        $adforest_render_params['s2_description'] = isset($steps_settings_fields['s2_description']) ? $steps_settings_fields['s2_description']:'';
        //step 1
        $adforest_render_params['s3_icon'] = isset($steps_settings_fields['s3_icon']) ? $steps_settings_fields['s3_icon']:'';
        $adforest_render_params['s3_title'] = isset($steps_settings_fields['s3_title']) ? $steps_settings_fields['s3_title']:'';
        $adforest_render_params['s3_description'] = isset($steps_settings_fields['s3_description']) ? $steps_settings_fields['s3_description']:'';
        
        echo process_cycle_short_base_func($adforest_render_params);
        
    }

}
