<?php
namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_search_minimal extends Widget_Base {

    public function get_name() {
        return 'search_minimal_short_base';
    }

    public function get_title() {
        return __('Search - Minimal','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'cat_setting', [
            'label' => esc_html__('Category','adforest-elementor'),
                ]
        );

        $this->add_control(
                'cat_frontend_switch', array(
            'label' => __('Category ( ajax based )','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('Default','adforest-elementor'),
                'ajax_based' => __('Ajax Based ( Load All )','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'cat', array(
            'label' => __('Select Category','adforest-elementor'),
            'type' => Controls_Manager::SELECT2,
            'default' => '',
            'multiple' => true,
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'cat_frontend_switch',
                        'operator' => 'in',
                        'value' => [
                            '',
                        ],
                    ],
                ],
            ],
            'options' => apply_filters('adforest_elementor_ads_categories', array(), 'ad_cats','yes')
                )
        );

        $this->end_controls_section();

    }

    protected function render() {
         $search_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE;
        
        $adforest_render_params['cat_frontend_switch'] = isset($search_settings_fields['cat_frontend_switch']) ? $search_settings_fields['cat_frontend_switch'] :'';
        $adforest_render_params['cats'] = isset($search_settings_fields['cat']) ? $search_settings_fields['cat']:'';
        
        echo search_minimal_short_base_func($adforest_render_params);
    }
}