<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_search_modern extends Widget_Base {

    public function get_name() {
        return 'search_modern_short_base';
    }

    public function get_title() {
        return __('Search - Modern','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'basic_settings', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );

        $this->add_control(
                'bg_img', array(
            'label' => __('Background Image','adforest-elementor'),
            'type' => Controls_Manager::MEDIA,
            "description" => __("1280x800", 'adforest-elementor'),
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                )
        );

        $this->add_control(
                'section_title', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'description' => __('For color {color}warp text within this tag{/color}','adforest-elementor'),
            'title' => __('Section Title','adforest-elementor'),
                ]
        );

        $this->add_control(
                'section_tag_line', [
            'label' => __('Section Tagline','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Section Tagline','adforest-elementor'),
            "description" => '%count% ' . __("for total ads", 'adforest-elementor'),
                ]
        );

        $this->add_control(
                'm_search_placeholder', [
            'label' => __('Search Place holder','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Search Place holder','adforest-elementor'),
                ]
        );

        $this->add_control(
                'm_location_placeholder', [
            'label' => __('Location Place holder','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Location Place holder','adforest-elementor'),
                ]
        );

        $this->add_control(
                'is_display_tags', array(
            'label' => __('Display tags ?','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '1' => __('Yes','adforest-elementor'),
                '0' => __('No','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'max_tags_limit', array(
            'label' => __('Max number of tags','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => 5,
            'min' => 1,
            'max' => 500,
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'is_display_tags',
                        'operator' => 'in',
                        'value' => [
                            '1',
                        ],
                    ],
                ],
            ],
                )
        );

        $this->end_controls_section();




        $this->start_controls_section(
                'cat_setting', [
            'label' => esc_html__('Category','adforest-elementor'),
                ]
        );

        $this->add_control(
                'cat_frontend_switch', array(
            'label' => __('Category ( ajax based )','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('Default','adforest-elementor'),
                'ajax_based' => __('Ajax Based ( Load All )','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'cat', array(
            'label' => __('Select Category','adforest-elementor'),
            'type' => Controls_Manager::SELECT2,
            'default' => '',
            'multiple' => true,
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'cat_frontend_switch',
                        'operator' => 'in',
                        'value' => [
                            '',
                        ],
                    ],
                ],
            ],
            'options' => apply_filters('adforest_elementor_ads_categories', array(), 'ad_cats','yes')
                )
        );

        $this->end_controls_section();



        $this->start_controls_section(
                'loc_settings', [
            'label' => esc_html__('Custom Loctions','adforest-elementor'),
                ]
        );

        $this->add_control(
                'location_type', array(
            'label' => __('Location type','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'g_locations' => __('Google','adforest-elementor'),
                'custom_locations' => __('Custom Location','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'locations', array(
            'label' => __('Locations','adforest-elementor'),
            'type' => Controls_Manager::SELECT2,
            'default' => '',
            'multiple' => true,
             'conditions' => [
                'terms' => [
                    [
                        'name' => 'location_type',
                        'operator' => 'in',
                        'value' => [
                            'custom_locations',
                        ],
                    ],
                ],
            ],
            'options' => apply_filters('adforest_elementor_ads_categories', array(), 'ad_country', 'yes')
                )
        );
        $this->end_controls_section();
    }

    protected function render() {

        $search_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['bg_img'] = isset($search_settings_fields['bg_img']['id']) && $search_settings_fields['bg_img']['id'] != '' ? $search_settings_fields['bg_img']['id'] : '';
        $adforest_render_params['section_title'] = isset($search_settings_fields['section_title']) ? $search_settings_fields['section_title']:'';

        $adforest_render_params['section_tag_line'] = isset($search_settings_fields['section_tag_line']) ? $search_settings_fields['section_tag_line'] :'';
        $adforest_render_params['m_search_placeholder'] = isset($search_settings_fields['m_search_placeholder']) ? $search_settings_fields['m_search_placeholder']:'';
        $adforest_render_params['m_location_placeholder'] = isset($search_settings_fields['m_location_placeholder']) ? $search_settings_fields['m_location_placeholder']:'';
        $adforest_render_params['is_display_tags'] = isset($search_settings_fields['is_display_tags']) ? $search_settings_fields['is_display_tags'] :'';
        $adforest_render_params['max_tags_limit'] = isset($search_settings_fields['max_tags_limit']) ? $search_settings_fields['max_tags_limit']:'';


        $adforest_render_params['cat_frontend_switch'] = isset($search_settings_fields['cat_frontend_switch']) ? $search_settings_fields['cat_frontend_switch']:'';
        $adforest_render_params['cats'] = isset($search_settings_fields['cat']) ? $search_settings_fields['cat']:'';

        $adforest_render_params['location_type'] = isset($search_settings_fields['location_type']) ? $search_settings_fields['location_type']:'';
        $adforest_render_params['locations'] = isset($search_settings_fields['locations']) ? $search_settings_fields['locations']:'';


        echo search_modern_short_base_func($adforest_render_params);
    }

}
