<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_Vendor_Banner extends Widget_Base
{

    public function get_name()
    {
        return 'vendor_banner_short_base';
    }

    public function get_title()
    {
        return __('Adforest - Vendor Banner', 'adforest-elementor');
    }

    public function get_icon()
    {
        return 'fa fa-audio-description';
    }

    public function get_categories()
    {
        return ['adforest_elementor'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'basic', [
                'label' => esc_html__('Basic', 'adforest-elementor'),
            ]
        );

        $this->add_control(
            'vendor_baner_img', array(
                'label' => __('Banner Image', 'adforest-elementor'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                "description" => __("1220x88", 'adforest-elementor'),
            )
        );

        $this->add_control(
            'vendor_baner_img_link', [
                'label' => __('Banner Image Link', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '#',
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $app_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        $adforest_render_params['adforest_elementor'] = TRUE;

        $adforest_render_params['vendor_baner_img'] = isset($app_settings_fields['vendor_baner_img']['id']) ? $app_settings_fields['vendor_baner_img']['id'] : '';
        $adforest_render_params['vendor_baner_img_link'] = isset($app_settings_fields['vendor_baner_img_link']) ? $app_settings_fields['vendor_baner_img_link'] : '';

        echo adforest_vendor_baner_func($adforest_render_params);

    }

}
