<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_Vendor_Services extends Widget_Base
{

    public function get_name()
    {
        return 'vendor_services_short_base';
    }

    public function get_title()
    {
        return __('Adforest - Vendor Services', 'adforest-elementor');
    }

    public function get_icon()
    {
        return 'fa fa-audio-description';
    }

    public function get_categories()
    {
        return ['adforest_elementor'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'basic', [
                'label' => esc_html__('Basic', 'adforest-elementor'),
            ]
        );
        $this->add_control(
            'header_style', array(
                'label' => __('Header Style', 'adforest-elementor'),
                'type' => Controls_Manager::SELECT,

                'options' => array(
                    '' => __('No Header', 'adforest-elementor'),
                    'classic' => __('Classic', 'adforest-elementor'),
                    'regular' => __('Regular', 'adforest-elementor'),
                ),
            )
        );

        $this->add_control(
            'section_title', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'description' => __('For color {color}warp text within this tag{/color}', 'adforest-elementor'),
                'title' => __('Section Title', 'adforest-elementor'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'classic',
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'section_title_regular', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'title' => __('Section Title', 'adforest-elementor'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'regular',
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'section_description', [
                'label' => __('Section Description', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'title' => '',
                'rows' => 3,
                'placeholder' => '',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => [
                                'classic',
                            ],
                        ],
                    ],
                ],

            ]
        );
        $this->end_controls_section();

        /*
         * Services
         */
        $this->start_controls_section(
            'vendor_services_sec', [
                'label' => esc_html__('Services', 'adforest-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'vservice_icon_img', array(
                'label' => __('Icon Image', 'adforest-elementor'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                "description" => __("42x28", 'adforest-elementor'),
            )
        );
        $repeater->add_control(
            'vservice_title', [
                'label' => __('Section Title', 'adforest-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '#',
            ]
        );
        $repeater->add_control(
            'vservice_desc', [
                'label' => __('Section Description', 'adforest-elementor'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '#',
            ]
        );
        $this->add_control(
            'vendor_services',
            [
                'label' => __('Banner Left and Right Image', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'vservice_title' => '',
                        'vservice_desc' => '',
                        'vservice_icon_img' => '',
                    ],
                ],
            ]
        );
        $this->end_controls_section();
        //===============
    }

    protected function render()
    {
        $app_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();

        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['section_bg'] = isset($app_settings_fields['section_bg']) ? $app_settings_fields['section_bg'] : '';
        $adforest_render_params['bg_img'] = isset($app_settings_fields['bg_img']['id']) ? $app_settings_fields['bg_img']['id'] : '';
        $adforest_render_params['header_style'] = isset($app_settings_fields['header_style']) ? $app_settings_fields['header_style'] : '';
        $adforest_render_params['section_title'] = isset($app_settings_fields['section_title']) ? $app_settings_fields['section_title'] : '';
        $adforest_render_params['section_title_regular'] = isset($app_settings_fields['section_title_regular']) ? $app_settings_fields['section_title_regular'] : '';
        $adforest_render_params['section_description'] = isset($app_settings_fields['section_description']) ? $app_settings_fields['section_description'] : '';

        $adforest_render_params['vendor_services'] = isset($app_settings_fields['vendor_services']) ? $app_settings_fields['vendor_services'] : array();
        echo adforest_vendor_services_func($adforest_render_params);

    }

}
