<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_y_ads_google_map_modern extends Widget_Base {

    public function get_name() {
        return 'ads_google_map_short_base';
    }

    public function get_title() {
        return __('ADs - Google Map Modern','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'ads_settings11', [
            'label' => esc_html__('Ads Settings','adforest-elementor'),
                ]
        );
        $this->add_control(
                'ad_type', [
            'label' => __('Ads Type','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            //'multiple' => true,
            "description" => __("Select Ads Type", 'adforest-elementor'),
            'options' => [
                'feature' => __('Featured Ads','adforest-elementor'),
                'regular' => __('Simple Ads','adforest-elementor'),
                'both' => __('Both','adforest-elementor'),
            ],
                ]
        );
        $this->add_control(
                'ad_order', [
            'label' => __('Order By','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            // 'multiple' => true,
            "description" => __("Select Ads order", 'adforest-elementor'),
            'options' => [
                'asc' => __('Oldest','adforest-elementor'),
                'desc' => __('Latest','adforest-elementor'),
                'rand' => __('Random','adforest-elementor'),
            ],
                ]
        );
        $this->add_control(
                'no_of_ads', [
            'label' => __('Number fo Ads for each category','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 1,
            'max' => 500,
            'step' => 1,
            'default' => 1,
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
                'map_section1', [
            'label' => __('Map','adforest-elementor'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
        );

        $this->add_control(
                'map_marker_img', [
            'label' => __('Map Marker','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            "description" => __("50x77", 'adforest-elementor'),
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );
        $this->add_control(
                'map_marker_more_img', [
            'label' => __('Map Marker Many','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            "description" => __("50x77", 'adforest-elementor'),
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );
        $this->add_control(
                'map_latitude', [
            'label' => __('Latitude','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXT,
            "description" => __("That Area will be display in map after loading but user can change it by dragging."),
                ]
        );
        $this->add_control(
                'map_longitude', [
            'label' => __('Longitude','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXT,
                ]
        );
        $this->add_control(
                'map_zoom', [
            'label' => __('Map Zoom','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 1,
            'max' => 12,
            'step' => 1,
            'default' => 6,
                ]
        );
        $this->add_control(
                'map_info_address_limit', [
            'label' => __('Map infobox address limit','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXT,
            "description" => __("Characters limit should be integer value", 'adforest-elementor'),
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'category_section_selec22', [
            'label' => __('Categories','adforest-elementor'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
        );



        $this->add_control(
                'cats', [
            'label' => __('Select Category','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'options' => apply_filters('adforest_elementor_ads_categories', array(), 'ad_cats'),
            'label_block' => true,
            'multiple' => true,
                ]
        );

        $this->end_controls_section();
    }

    protected function render() {

        $ads_google_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['ad_type'] = isset($ads_google_settings_fields['ad_type']) ? $ads_google_settings_fields['ad_type']:'';
        $adforest_render_params['ad_order'] = isset($ads_google_settings_fields['ad_order']) ? $ads_google_settings_fields['ad_order']:'';
        $adforest_render_params['no_of_ads'] = isset($ads_google_settings_fields['no_of_ads']) ? $ads_google_settings_fields['no_of_ads']:'';
        $adforest_render_params['map_marker_img'] = isset($ads_google_settings_fields['map_marker_img']['id']) ? $ads_google_settings_fields['map_marker_img']['id'] : '';
        $adforest_render_params['map_marker_more_img'] = isset($ads_google_settings_fields['map_marker_more_img']['id']) ? $ads_google_settings_fields['map_marker_more_img']['id'] : '';
        $adforest_render_params['map_latitude'] = isset($ads_google_settings_fields['map_latitude']) ? $ads_google_settings_fields['map_latitude']:'';
        $adforest_render_params['map_longitude'] = isset($ads_google_settings_fields['map_longitude']) ? $ads_google_settings_fields['map_longitude']:'';
        $adforest_render_params['map_zoom'] = isset($ads_google_settings_fields['map_zoom']) ? $ads_google_settings_fields['map_zoom']:'';
        $adforest_render_params['map_info_address_limit'] = isset($ads_google_settings_fields['map_info_address_limit']) ? $ads_google_settings_fields['map_info_address_limit']:'';
        $adforest_render_params['cats'] = isset($ads_google_settings_fields['cats']) ? $ads_google_settings_fields['cats']:'';

        echo ads_google_map_short_base_func($adforest_render_params);
    }

}
