<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_y_apps2 extends Widget_Base {

    public function get_name() {
        return 'apps2_short_base';
    }

    public function get_title() {
        return __('Apps - Simple 2','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'basic', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );
        $this->add_control(
                'bg_img', [
            'label' => __('Main Image','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            "description" => __("448x378", 'adforest-elementor'),
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );

        $this->add_control(
                'section_bg', [
            'label' => __('Background Color','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            //'multiple' => true,
            "description" => __("Select background color", 'adforest-elementor'),
            'options' => [
                '' => __('White','adforest-elementor'),
                'gray' => __('Gray','adforest-elementor'),
            ],
                ]
        );

        $this->add_control(
                'section_title', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXT,
                ]
        );
        $this->add_control(
                'tag_line', [
            'label' => __('Tagline','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXT,
                ]
        );
        $this->add_control(
                'section_description', [
            'label' => __('Section Description','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
                'android_section', [
            'label' => esc_html__('Android','adforest-elementor'),
                ]
        );
        $this->add_control(
                'a_link', [
            'label' => __('Download Link','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXT,
                ]
        );
        $this->add_control(
                'android_img', [
            'label' => __('Android image','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            "description" => __("167x49", 'adforest-elementor'),
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
                'ios_section', [
            'label' => esc_html__('IOS','adforest-elementor'),
                ]
        );
        $this->add_control(
                'i_link', [
            'label' => __('Download Link','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXT,
                ]
        );
        $this->add_control(
                'ios_img', [
            'label' => __('IOS image','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            "description" => __("167x49", 'adforest-elementor'),
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );
        $this->end_controls_section();
    }

    protected function render() {

        $app_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['bg_img'] = isset($app_settings_fields['bg_img']['id']) ? $app_settings_fields['bg_img']['id'] : '';
        $adforest_render_params['section_bg'] = isset($app_settings_fields['section_bg']) ? $app_settings_fields['section_bg']:'';
        $adforest_render_params['section_title'] = isset($app_settings_fields['section_title']) ? $app_settings_fields['section_title']:'';
        $adforest_render_params['tag_line'] = isset($app_settings_fields['tag_line']) ? $app_settings_fields['tag_line']:'';
        $adforest_render_params['section_description'] = isset($app_settings_fields['section_description']) ? $app_settings_fields['section_description']:'';
        $adforest_render_params['a_link'] = isset($app_settings_fields['a_link']) ? $app_settings_fields['a_link']:'';
        $adforest_render_params['android_img'] = isset($app_settings_fields['android_img']['id']) ? $app_settings_fields['android_img']['id'] : '';
        $adforest_render_params['i_link'] = isset($app_settings_fields['i_link']) ? $app_settings_fields['i_link']:'';
        $adforest_render_params['ios_img'] = isset($app_settings_fields['ios_img']['id']) ? $app_settings_fields['ios_img']['id'] : '';
        echo apps2_short_base_func($adforest_render_params);
    }
}