<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_y_grid_modern extends Widget_Base {

    public function get_name() {
        return 'grid_modern_type_short_base';
    }

    public function get_title() {
        return __('Grid - Modern','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'basic', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );
        $this->add_control(
                'cat_link_page', [
            'label' => __('Category link Page','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            //'multiple' => true,
            'options' => [
                'search' => __('Search Page','adforest-elementor'),
                'category' => __('Category Page','adforest-elementor'),
            ],
                ]
        );
        $this->add_control(
                'cat_section_title', [
            'label' => __('Category Section Title','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXT,
                ]
        );

        $this->add_control(
                'ads_section_title', [
            'label' => __('Ads Section Title','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXT,
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
                'ad_settings', [
            'label' => esc_html__('Ads Settings','adforest-elementor'),
                ]
        );
        $this->add_control(
                'ad_type', [
            'label' => __('Ads Type','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            //'multiple' => true,
            'description' => __('Select Ads Type','adforest-elementor'),
            'options' => [
                'feature' => __('Featured Ads','adforest-elementor'),
                'regular' => __('Simple Ads','adforest-elementor'),
                'both' => __('Both','adforest-elementor'),
            ],
                ]
        );
        $this->add_control(
                'ad_order', [
            'label' => __('Order By','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            //'multiple' => true,
            'description' => __('Select Ads order','adforest-elementor'),
            'options' => [
                'asc' => __('Oldest','adforest-elementor'),
                'desc' => __('Latest','adforest-elementor'),
                'rand' => __('Random','adforest-elementor'),
            ],
                ]
        );

        $this->add_control(
                'no_of_ads', [
            'label' => __('Number fo Ads to display','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 1,
            'max' => 500,
            'step' => 1,
            'default' => 1,
                ]
        );
        $this->add_control(
                'link_title', [
            'label' => __('Link Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Link Title','adforest-elementor'),
                ]
        );
        $this->add_control(
                'view_all', [
            'label' => __('View all button link','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::URL,
            'show_external' => true,
            'default' => [
                'url' => '',
                'is_external' => true,
                'nofollow' => true,
            ],
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
                'ad_category', [
            'label' => esc_html__('Categories for ads','adforest-elementor'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
        );

        $this->add_control(
                'cats', [
            'label' => __('Select Category ( Selective )','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => apply_filters('adforest_elementor_ads_categories', array(), 'ad_cats'),
                ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
                'ad_category1', [
            'label' => esc_html__('Categories','adforest-elementor'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
        );
        $repeater22 = new \Elementor\Repeater();
        $repeater22->add_control(
                'cat', [
            'label' => __('Select Category ( Selective )','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => apply_filters('adforest_elementor_ads_categories', array(), 'ad_cats'),
                ]
        );
        $repeater22->add_control(
                'img', [
            'label' => __('Category Image','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'description' => __('100x100','adforest-elementor'),
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );
        $this->add_control(
                'cats_round', [
            'label' =>'',
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater22->get_controls(),
            'title_field' => '{{{ cat }}}',
                ]
        );
        $this->end_controls_section();
    }

    protected function render() {

        $fun_facts_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['cat_link_page'] = isset($fun_facts_settings_fields['cat_link_page']) ? $fun_facts_settings_fields['cat_link_page']:'';
        $adforest_render_params['cat_section_title'] = isset($fun_facts_settings_fields['cat_section_title']) ? $fun_facts_settings_fields['cat_section_title']:'';
        $adforest_render_params['ads_section_title'] = isset($fun_facts_settings_fields['ads_section_title']) ? $fun_facts_settings_fields['ads_section_title']:'';
        $adforest_render_params['ad_type'] = isset($fun_facts_settings_fields['ad_type']) ? $fun_facts_settings_fields['ad_type']:'';
        $adforest_render_params['ad_order'] = isset($fun_facts_settings_fields['ad_order']) ? $fun_facts_settings_fields['ad_order']:'';
        $adforest_render_params['no_of_ads'] = isset($fun_facts_settings_fields['no_of_ads']) ? $fun_facts_settings_fields['no_of_ads']:'';
        $adforest_render_params['view_all'] = isset($fun_facts_settings_fields['view_all']) ? $fun_facts_settings_fields['view_all']:'';
        $adforest_render_params['link_title'] = isset($fun_facts_settings_fields['link_title']) ? $fun_facts_settings_fields['link_title']:'';
        $adforest_render_params['cats'] = isset($fun_facts_settings_fields['cats']) ? $fun_facts_settings_fields['cats']:'';
        $adforest_render_params['cats_round'] = isset($fun_facts_settings_fields['cats_round']) ?$fun_facts_settings_fields['cats_round']:'';
        echo grid_modern_type_short_base_func($adforest_render_params);
    }

}
