<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_y_search_hero extends Widget_Base {

    public function get_name() {
        return 'search_hero_short_base';
    }

    public function get_title() {
        return __('Search - with bg-video','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'basic', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );
        $this->add_control(
                'section_video',
                [
                    'label' => __('BG Video','adforest-elementor'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    "description" => __("Youtube video url", 'adforest-elementor'),
                ]
        );
        $this->add_control(
                'section_title',
                [
                    'label' => __('Section Title','adforest-elementor'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    "description" =>"%count% " . __( "for total ads", 'adforest-elementor'),
                ]
        );
        $this->add_control(
                'section_tag_line',
                [
                    'label' => __('Section Tagline','adforest-elementor'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                ]
        );


        $this->end_controls_section();
    }

    protected function render() {

        $search_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        $adforest_render_params['adforest_elementor'] = TRUE;
        $adforest_render_params['section_video'] = isset($search_settings_fields['section_video']) ? $search_settings_fields['section_video']:'';
        $adforest_render_params['section_title'] = isset($search_settings_fields['section_title']) ? $search_settings_fields['section_title']:'';
        $adforest_render_params['section_tag_line'] = isset($search_settings_fields['section_tag_line']) ? $search_settings_fields['section_tag_line']:'';
        echo search_hero_short_base_func($adforest_render_params);
    }

}