<?php
namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_z_adforest_users extends Widget_Base {

    public function get_name() {
        return 'Adforest Users';
    }

    public function get_title() {
        return __('Adforest Users','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

       $this->start_controls_section(
                'basic', [
            'label' => esc_html__('Basic','adforest-elementor'),
                ]
        );

        $this->add_control(
                'section_bg', array(
            'label' => __('Background Color','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'description' => __('Select background color.','adforest-elementor'),        
            'options' => array(
                '' => __('White','adforest-elementor'),
                'gray' => __('Gray','adforest-elementor'),
            ),
                )
        );
        
        
        
        
        $this->add_control(
                'header_style', array(
            'label' => __('Header Style','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'description' => __('Chose header style.','adforest-elementor'),        
            'options' => array(
                '' => __('No Header','adforest-elementor'),
                'classic' => __('Classic','adforest-elementor'),
                'regular' => __('Regular','adforest-elementor'),
            ),
                )
        );

        $this->add_control(
                'section_title', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Section Title','adforest-elementor'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'classic',
                        ],
                    ],
                ],
            ],
             'description' => __('For color {color}warp text within this tag{/color}','adforest-elementor'),        
        
                ]
        );
         $this->add_control(
                'section_description', [
            'label' => __('Section Description','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'title' => '',
            'rows' => 3,
            'placeholder' => '',
             'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'classic',
                        ],
                    ],
                ],
            ],
                    
                ]
        );
        $this->add_control(
                'section_title_regular', [
            'label' => __('Section Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Section Title','adforest-elementor'),
            'conditions' => [
                'terms' => [
                    [
                        'name' => 'header_style',
                        'operator' => 'in',
                        'value' => [
                            'regular',
                        ],
                    ],
                ],
            ],
                ]
        );

        
       
     
        $this->end_controls_section(); 
        
        
        $this->start_controls_section(
                'adset', [
            'label' => esc_html__('Ads Settings','adforest-elementor'),
                ]
        );
        
         $this->add_control(
                'show_users', array(
            'label' => __('Display Users','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'all' => __('All','adforest-elementor'),
                'seller' => __('Sellers only','adforest-elementor'),
                
            ),
                )
        );
        $this->add_control(
                'user_pagination', array(
            'label' => __('Pagination','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'no' => __('Disable','adforest-elementor'),
                'yes' => __('Enable','adforest-elementor'),
                
            ),
                )
        );
        
        $this->add_control(
	        'no_of_user',
	         [
		'label' => __('Number of Users','adforest-elementor' ),
		'type' => \Elementor\Controls_Manager::NUMBER,
		'min' => 1,
		'max' => 500,
		'step' => 1,
		'default' => 1,
                
			]
		); 
        
         $this->add_control(
                'show_reviews', array(
            'label' => __('Display Reviews','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'no' => __('Disable','adforest-elementor'),
                'yes' => __('Enable','adforest-elementor'),
                
            ),
                )
        );
         
         $this->add_control(
                'show_ads', array(
            'label' => __('Display Ads Count','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'no' => __('Disable','adforest-elementor'),
                'yes' => __('Enable','adforest-elementor'),
                
            ),
                )
        );
         
         $this->add_control(
                'user_order', array(
            'label' => __('User Order','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => __('ASC','adforest-elementor'),
                'DESC' => __('DESC','adforest-elementor'),
                
            ),
                )
        ); 
        
        
        
        
         $this->end_controls_section(); 
        
        
        


    }

    protected function render() {
    $package_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE; 
        
        
        $adforest_render_params['section_bg'] = isset($package_settings_fields['section_bg']) ? $package_settings_fields['section_bg'] : '';
        $adforest_render_params['header_style'] = isset($package_settings_fields['header_style']) ? $package_settings_fields['header_style'] : '';
        $adforest_render_params['section_title'] = isset($package_settings_fields['section_title']) ? $package_settings_fields['section_title'] : '';
        $adforest_render_params['section_description'] = isset($package_settings_fields['section_description']) ? $package_settings_fields['section_description'] : '';
        $adforest_render_params['section_title_regular'] = isset($package_settings_fields['section_title_regular']) ? $package_settings_fields['section_title_regular'] : '';
        
        $adforest_render_params['show_users'] = isset($package_settings_fields['ads_columns']) ? $package_settings_fields['ads_columns'] : '';
        $adforest_render_params['user_pagination'] = isset($package_settings_fields['user_pagination']) ? $package_settings_fields['user_pagination'] : '';
        $adforest_render_params['no_of_user'] = isset($package_settings_fields['no_of_user']) ? $package_settings_fields['no_of_user'] : '';
        $adforest_render_params['show_reviews'] = isset($package_settings_fields['show_reviews']) ? $package_settings_fields['show_reviews'] : '';
        $adforest_render_params['show_ads'] = isset($package_settings_fields['show_ads']) ? $package_settings_fields['show_ads'] : '';
         $adforest_render_params['user_order'] = isset($package_settings_fields['user_order']) ? $package_settings_fields['user_order'] : '';
          
         echo adforest_users_callback($adforest_render_params);
        
    }
}